/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.asm.optimizer;

import br.com.caelum.vraptor.asm.AnnotationVisitor;
import br.com.caelum.vraptor.asm.Attribute;
import br.com.caelum.vraptor.asm.ClassAdapter;
import br.com.caelum.vraptor.asm.ClassVisitor;
import br.com.caelum.vraptor.asm.FieldVisitor;
import br.com.caelum.vraptor.asm.MethodVisitor;
import br.com.caelum.vraptor.asm.optimizer.AnnotationConstantsCollector;
import br.com.caelum.vraptor.asm.optimizer.ConstantPool;
import br.com.caelum.vraptor.asm.optimizer.FieldConstantsCollector;
import br.com.caelum.vraptor.asm.optimizer.MethodConstantsCollector;

public class ClassConstantsCollector
extends ClassAdapter {
    private final ConstantPool cp;

    public ClassConstantsCollector(ClassVisitor cv, ConstantPool cp) {
        super(cv);
        this.cp = cp;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x20000) != 0) {
            this.cp.newUTF8("Deprecated");
        }
        if ((access & 0x1000) != 0) {
            this.cp.newUTF8("Synthetic");
        }
        this.cp.newClass(name);
        if (signature != null) {
            this.cp.newUTF8("Signature");
            this.cp.newUTF8(signature);
        }
        if (superName != null) {
            this.cp.newClass(superName);
        }
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                this.cp.newClass(interfaces[i]);
            }
        }
        this.cv.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSource(String source, String debug) {
        if (source != null) {
            this.cp.newUTF8("SourceFile");
            this.cp.newUTF8(source);
        }
        if (debug != null) {
            this.cp.newUTF8("SourceDebugExtension");
        }
        this.cv.visitSource(source, debug);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.cp.newUTF8("EnclosingMethod");
        this.cp.newClass(owner);
        if (name != null && desc != null) {
            this.cp.newNameType(name, desc);
        }
        this.cv.visitOuterClass(owner, name, desc);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleAnnotations");
        }
        return new AnnotationConstantsCollector(this.cv.visitAnnotation(desc, visible), this.cp);
    }

    public void visitAttribute(Attribute attr) {
        this.cv.visitAttribute(attr);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.cp.newUTF8("InnerClasses");
        if (name != null) {
            this.cp.newClass(name);
        }
        if (outerName != null) {
            this.cp.newClass(outerName);
        }
        if (innerName != null) {
            this.cp.newUTF8(innerName);
        }
        this.cv.visitInnerClass(name, outerName, innerName, access);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 0x1000) != 0) {
            this.cp.newUTF8("Synthetic");
        }
        if ((access & 0x20000) != 0) {
            this.cp.newUTF8("Deprecated");
        }
        this.cp.newUTF8(name);
        this.cp.newUTF8(desc);
        if (signature != null) {
            this.cp.newUTF8("Signature");
            this.cp.newUTF8(signature);
        }
        if (value != null) {
            this.cp.newConst(value);
        }
        return new FieldConstantsCollector(this.cv.visitField(access, name, desc, signature, value), this.cp);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x1000) != 0) {
            this.cp.newUTF8("Synthetic");
        }
        if ((access & 0x20000) != 0) {
            this.cp.newUTF8("Deprecated");
        }
        this.cp.newUTF8(name);
        this.cp.newUTF8(desc);
        if (signature != null) {
            this.cp.newUTF8("Signature");
            this.cp.newUTF8(signature);
        }
        if (exceptions != null) {
            this.cp.newUTF8("Exceptions");
            for (int i = 0; i < exceptions.length; ++i) {
                this.cp.newClass(exceptions[i]);
            }
        }
        return new MethodConstantsCollector(this.cv.visitMethod(access, name, desc, signature, exceptions), this.cp);
    }
}

