/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.config;

import br.com.caelum.vraptor.ioc.ContainerProvider;
import br.com.caelum.vraptor.ioc.spring.MissingConfigurationException;
import br.com.caelum.vraptor.ioc.spring.SpringProvider;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class BasicConfiguration {
    public static final String CONTAINER_PROVIDER = "br.com.caelum.vraptor.provider";
    public static final String ENCODING = "br.com.caelum.vraptor.encoding";
    public static final String BASE_PACKAGES_PARAMETER_NAME = "br.com.caelum.vraptor.packages";
    private final ServletContext servletContext;

    public BasicConfiguration(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ContainerProvider getProvider() throws ServletException {
        String provider = this.servletContext.getInitParameter(CONTAINER_PROVIDER);
        if (provider == null) {
            provider = SpringProvider.class.getName();
        }
        try {
            return (ContainerProvider)Class.forName(provider).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new ServletException(e.getCause());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public boolean hasBasePackages() {
        return this.servletContext.getInitParameter(BASE_PACKAGES_PARAMETER_NAME) != null;
    }

    public String[] getBasePackages() {
        String packages = this.servletContext.getInitParameter(BASE_PACKAGES_PARAMETER_NAME);
        if (packages == null) {
            throw new MissingConfigurationException("br.com.caelum.vraptor.packages context-param not found in web.xml. Set this parameter with your base package");
        }
        return packages.split(",");
    }

    public String getEncoding() {
        return this.servletContext.getInitParameter(ENCODING);
    }

    public String getWebinfClassesDirectory() {
        return this.servletContext.getRealPath("/WEB-INF/classes/");
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

