/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.ioc.Container;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedConverters
implements Converters {
    private final Converters delegate;
    private final Map<Class<?>, Class<?>> cache = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(CachedConverters.class);

    public CachedConverters(Converters converters) {
        this.delegate = converters;
    }

    @Override
    public Converter<?> to(Class<?> type, Container container) {
        if (this.cache.containsKey(type)) {
            Class<?> converterType = this.cache.get(type);
            return (Converter)container.instanceFor(converterType);
        }
        logger.debug("Caching converter " + type.getName());
        Converter<?> converter = this.delegate.to(type, container);
        this.cache.put(type, converter.getClass());
        return converter;
    }

    @Override
    public void register(Class<? extends Converter<?>> converterClass) {
        throw new UnsupportedOperationException("cannot add vr3 converters in cached converters container (or should we delegate?");
    }

    @Override
    public boolean existsFor(Class<?> type, Container container) {
        if (this.cache.containsKey(type)) {
            return true;
        }
        return this.delegate.existsFor(type, container);
    }
}

