/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import java.text.MessageFormat;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Convert(value=float.class)
@ApplicationScoped
public class PrimitiveFloatConverter
implements Converter<Float> {
    @Override
    public Float convert(String value, Class<? extends Float> type, ResourceBundle bundle) {
        if (value == null || value.equals("")) {
            return Float.valueOf(0.0f);
        }
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            throw new ConversionError(MessageFormat.format(bundle.getString("is_not_a_valid_number"), value));
        }
    }
}

