/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter.jodatime;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.converter.LocaleBasedCalendarConverter;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.ResourceBundle;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Convert(value=LocalDate.class)
public class LocalDateConverter
implements Converter<LocalDate> {
    private final LocaleBasedCalendarConverter delegate;

    public LocalDateConverter(LocaleBasedCalendarConverter delegate) {
        this.delegate = delegate;
    }

    @Override
    public LocalDate convert(String value, Class<? extends LocalDate> type, ResourceBundle bundle) {
        Object calendar = this.delegate.convert(value, Calendar.class, bundle);
        if (calendar == null) {
            return null;
        }
        try {
            return LocalDate.fromCalendarFields((Calendar)calendar);
        }
        catch (Exception e) {
            throw new ConversionError(MessageFormat.format(bundle.getString("is_not_a_valid_date"), value));
        }
    }
}

