/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter.l10n;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.converter.JstlWrapper;
import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.ioc.RequestScoped;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Convert(value=Double.class)
@RequestScoped
public class LocaleBasedDoubleConverter
implements Converter<Double> {
    private final JstlWrapper jstlWrapper = new JstlWrapper();
    private final RequestInfo request;

    public LocaleBasedDoubleConverter(RequestInfo request) {
        this.request = request;
    }

    @Override
    public Double convert(String value, Class<? extends Double> type, ResourceBundle bundle) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        try {
            Locale locale = this.jstlWrapper.findLocale(this.request);
            DecimalFormat fmt = new DecimalFormat("##0,00", new DecimalFormatSymbols(locale));
            return fmt.parse(value).doubleValue();
        }
        catch (ParseException e) {
            throw new ConversionError(MessageFormat.format(bundle.getString("is_not_a_valid_number"), value));
        }
    }
}

