/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter.l10n;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.converter.JstlWrapper;
import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.ioc.RequestScoped;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Convert(value=Float.class)
@RequestScoped
public class LocaleBasedFloatConverter
implements Converter<Float> {
    private final JstlWrapper jstlWrapper = new JstlWrapper();
    private final RequestInfo request;

    public LocaleBasedFloatConverter(RequestInfo request) {
        this.request = request;
    }

    @Override
    public Float convert(String value, Class<? extends Float> type, ResourceBundle bundle) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        try {
            Locale locale = this.jstlWrapper.findLocale(this.request);
            DecimalFormat fmt = new DecimalFormat("##0,00", new DecimalFormatSymbols(locale));
            return Float.valueOf(fmt.parse(value).floatValue());
        }
        catch (ParseException e) {
            throw new ConversionError(MessageFormat.format(bundle.getString("is_not_a_valid_number"), value));
        }
    }
}

