/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.VRaptorException;
import br.com.caelum.vraptor.converter.jodatime.LocalDateConverter;
import br.com.caelum.vraptor.converter.jodatime.LocalTimeConverter;
import br.com.caelum.vraptor.core.BaseComponents;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.Container;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public final class DefaultConverters
implements Converters {
    private final LinkedList<Class<? extends Converter<?>>> classes;
    private final Logger logger = LoggerFactory.getLogger(DefaultConverters.class);

    public DefaultConverters() {
        this.classes = new LinkedList();
        this.logger.info("Registering bundled converters");
        for (Class<? extends Converter<?>> converterType : BaseComponents.getBundledConverters()) {
            this.logger.debug("bundled converter to be registered: " + converterType);
            this.register(converterType);
        }
        try {
            Class.forName("org.joda.time.LocalDate");
            this.register(LocalDateConverter.class);
            this.register(LocalTimeConverter.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void register(Class<? extends Converter<?>> converterClass) {
        if (!converterClass.isAnnotationPresent(Convert.class)) {
            throw new VRaptorException("The converter type " + converterClass.getName() + " should have the Convert annotation");
        }
        this.classes.addFirst(converterClass);
    }

    @Override
    public Converter<?> to(Class<?> clazz, Container container) {
        Converter<?> foundConverter = this.findConverterFor(clazz, container);
        if (foundConverter == null) {
            throw new VRaptorException("Unable to find converter for " + clazz.getName());
        }
        return foundConverter;
    }

    private Converter<?> findConverterFor(Class<?> clazz, Container container) {
        for (Class clazz2 : this.classes) {
            Class<?> boundType = clazz2.getAnnotation(Convert.class).value();
            if (!boundType.isAssignableFrom(clazz)) continue;
            return (Converter)container.instanceFor(clazz2);
        }
        return null;
    }

    @Override
    public boolean existsFor(Class<?> type, Container container) {
        return this.findConverterFor(type, container) != null;
    }
}

