/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.core.InstantiatedInterceptorHandler;
import br.com.caelum.vraptor.core.InterceptorHandler;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.core.ToInstantiateInterceptorHandler;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.ioc.PrototypeScoped;
import br.com.caelum.vraptor.resource.ResourceMethod;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PrototypeScoped
public class DefaultInterceptorStack
implements InterceptorStack {
    private static final Logger logger = LoggerFactory.getLogger(DefaultInterceptorStack.class);
    private final List<InterceptorHandler> interceptors = new ArrayList<InterceptorHandler>();
    private final Container container;
    private int nextInterceptor = 0;

    public DefaultInterceptorStack(Container container) {
        this.container = container;
    }

    @Override
    public void add(Interceptor interceptor) {
        this.interceptors.add(new InstantiatedInterceptorHandler(interceptor));
    }

    @Override
    public void next(ResourceMethod method, Object resourceInstance) throws InterceptionException {
        if (this.nextInterceptor == this.interceptors.size()) {
            logger.debug("All registered interceptors have being called. End of VRaptor Request Execution.");
            return;
        }
        InterceptorHandler handler = this.interceptors.get(this.nextInterceptor++);
        handler.execute(this, method, resourceInstance);
    }

    @Override
    public <T extends Interceptor> void add(Class<T> type) {
        this.interceptors.add(new ToInstantiateInterceptorHandler(this.container, type));
    }

    @Override
    public void addAsNext(Interceptor interceptor) {
        this.interceptors.add(this.nextInterceptor, new InstantiatedInterceptorHandler(interceptor));
    }

    public String toString() {
        return "DefaultInterceptorStack " + this.interceptors;
    }
}

