/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.core.StaticContentHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStaticContentHandler
implements StaticContentHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStaticContentHandler.class);
    private final ServletContext context;

    public DefaultStaticContentHandler(ServletContext context) {
        this.context = context;
    }

    public boolean requestingStaticFile(HttpServletRequest request) throws MalformedURLException {
        URL resourceUrl = this.context.getResource(this.uriRelativeToContextRoot(request));
        return resourceUrl != null && this.isAFile(resourceUrl);
    }

    private String uriRelativeToContextRoot(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }

    private boolean isAFile(URL resourceUrl) {
        return !resourceUrl.toString().endsWith("/");
    }

    public void deferProcessingToContainer(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug("Deferring request to container: {} ", (Object)request.getRequestURI());
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

