/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.core.Localization;
import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.core.SafeResourceBundle;
import br.com.caelum.vraptor.ioc.RequestScoped;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class JstlLocalization
implements Localization {
    private static final Logger logger = LoggerFactory.getLogger(JstlLocalization.class);
    private static final String DEFAULT_BUNDLE_NAME = "messages";
    private final RequestInfo request;
    private ResourceBundle bundle;

    public JstlLocalization(RequestInfo request) {
        this.request = request;
    }

    public ResourceBundle getBundle() {
        if (this.bundle == null) {
            Locale locale = this.getLocale();
            Object bundle = this.get("javax.servlet.jsp.jstl.fmt.localizationContext");
            if (bundle instanceof String || bundle == null) {
                String baseName = (String)bundle;
                if (baseName == null) {
                    baseName = DEFAULT_BUNDLE_NAME;
                }
                try {
                    this.bundle = new SafeResourceBundle(ResourceBundle.getBundle(baseName, locale));
                }
                catch (MissingResourceException e) {
                    logger.debug("couldn't find message bundle, creating an empty one");
                    this.bundle = new SafeResourceBundle(this.createEmptyBundle());
                }
            } else if (bundle instanceof LocalizationContext) {
                LocalizationContext context = (LocalizationContext)bundle;
                this.bundle = context.getResourceBundle();
            } else {
                logger.warn("Can't handle bundle: " + bundle + ". Please report this bug. Using an empty bundle");
                this.bundle = new SafeResourceBundle(this.createEmptyBundle());
            }
        }
        return this.bundle;
    }

    private ResourceBundle createEmptyBundle() {
        try {
            return new PropertyResourceBundle(new ByteArrayInputStream(new byte[0]));
        }
        catch (IOException e) {
            logger.warn("It shouldn't happen. Please report this bug", (Throwable)e);
            return null;
        }
    }

    public Locale getLocale() {
        return this.localeFor("javax.servlet.jsp.jstl.fmt.locale");
    }

    public Locale getFallbackLocale() {
        return this.localeFor("javax.servlet.jsp.jstl.fmt.fallbackLocale");
    }

    private Locale localeFor(String key) {
        Object localeValue = this.get(key);
        if (localeValue instanceof String) {
            return this.stringToLocale((String)localeValue);
        }
        if (localeValue != null) {
            return (Locale)localeValue;
        }
        return this.request.getRequest().getLocale();
    }

    private Locale stringToLocale(String str) {
        int[] underscorePositions = this.underscorePositions(str);
        if (underscorePositions[0] == -1) {
            return new Locale(str);
        }
        String language = str.substring(0, underscorePositions[0]);
        if (underscorePositions[1] == -1) {
            return new Locale(language, str.substring(underscorePositions[0] + 1));
        }
        return new Locale(language, str.substring(underscorePositions[0] + 1, underscorePositions[1]), str.substring(underscorePositions[1] + 1));
    }

    private int[] underscorePositions(String str) {
        int[] result = new int[2];
        for (int i = 0; i < result.length; ++i) {
            int last = i == 0 ? 0 : result[i - 1];
            result[i] = str.indexOf(95, last + 1);
        }
        return result;
    }

    private Object get(String key) {
        Object value = Config.get((ServletRequest)this.request.getRequest(), (String)key);
        if (value != null) {
            return value;
        }
        value = Config.get((HttpSession)this.request.getRequest().getSession(), (String)key);
        if (value != null) {
            return value;
        }
        value = Config.get((ServletContext)this.request.getServletContext(), (String)key);
        if (value != null) {
            return value;
        }
        return this.request.getServletContext().getInitParameter(key);
    }

    public String getMessage(String key, String ... parameters) {
        try {
            String content = this.getBundle().getString(key);
            return MessageFormat.format(content, parameters);
        }
        catch (MissingResourceException e) {
            return "???" + key + "???";
        }
    }
}

