/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.core.InterceptorHandler;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.resource.ResourceMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToInstantiateInterceptorHandler
implements InterceptorHandler {
    private static final Logger logger = LoggerFactory.getLogger(ToInstantiateInterceptorHandler.class);
    private final Container container;
    private final Class<?> type;

    public ToInstantiateInterceptorHandler(Container container, Class<?> type) {
        this.container = container;
        this.type = type;
    }

    @Override
    public void execute(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        Interceptor interceptor = (Interceptor)Interceptor.class.cast(this.container.instanceFor(this.type));
        if (interceptor == null) {
            throw new InterceptionException("Unable to instantiate interceptor for " + this.type.getName() + ": the container returned null.");
        }
        if (interceptor.accepts(method)) {
            logger.debug("Invoking interceptor {}", (Object)interceptor.getClass().getSimpleName());
            interceptor.intercept(stack, method, resourceInstance);
        } else {
            stack.next(method, resourceInstance);
        }
    }

    public String toString() {
        return "ToInstantiateHandler for " + this.type.getName();
    }
}

