/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.deserialization;

import br.com.caelum.vraptor.deserialization.XMLDeserializer;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.Component;
import br.com.caelum.vraptor.resource.ResourceMethod;
import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@ApplicationScoped
public class XStreamXMLDeserializer
implements XMLDeserializer {
    private final ParameterNameProvider provider;

    public XStreamXMLDeserializer(ParameterNameProvider provider) {
        this.provider = provider;
    }

    @Override
    public Object[] deserialize(InputStream inputStream, ResourceMethod method) {
        Method javaMethod = method.getMethod();
        Class<?>[] types = javaMethod.getParameterTypes();
        if (types.length == 0) {
            throw new IllegalArgumentException("Methods that consumes xml must receive just one argument: the xml root element");
        }
        XStream xStream = this.getConfiguredXStream(javaMethod, types);
        Object[] params = new Object[types.length];
        this.chooseParam(types, params, xStream.fromXML(inputStream));
        return params;
    }

    public XStream getConfiguredXStream(Method javaMethod, Class<?>[] types) {
        XStream xStream = this.getXStream();
        this.aliasParams(javaMethod, types, xStream);
        return xStream;
    }

    private void chooseParam(Class<?>[] types, Object[] params, Object deserialized) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isInstance(deserialized)) continue;
            params[i] = deserialized;
        }
    }

    private void aliasParams(Method method, Class<?>[] types, XStream deserializer) {
        String[] names = this.provider.parameterNamesFor(method);
        for (int i = 0; i < names.length; ++i) {
            deserializer.alias(names[i], types[i]);
        }
    }

    protected XStream getXStream() {
        return new XStream();
    }
}

