/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http;

import br.com.caelum.vraptor.VRaptorException;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.http.TypeCreator;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.vraptor2.Info;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeCreator
implements TypeCreator {
    private final ParameterNameProvider provider;

    public AbstractTypeCreator(ParameterNameProvider provider) {
        this.provider = provider;
    }

    @Override
    public final Object instanceWithParameters(ResourceMethod method, Object ... parameters) {
        String[] names = this.provider.parameterNamesFor(method.getMethod());
        Class<?> parameterType = this.typeFor(method);
        try {
            Object root = parameterType.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (int i = 0; i < names.length; ++i) {
                Method setter = this.findSetter(parameterType, "set" + Info.capitalize(names[i]));
                setter.invoke(root, parameters[i]);
            }
            return root;
        }
        catch (Exception e) {
            throw new VRaptorException(e);
        }
    }

    private Method findSetter(Class<?> parameterType, String methodName) {
        for (Method m : parameterType.getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        throw new VRaptorException("Unable to instanciate parameters as setter method for parameter setting was not created. Thats probably a bug on your type creator. If you are using the default type creator, notify VRaptor.");
    }
}

