/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http;

import br.com.caelum.vraptor.IteratorToEnumerationAdapter;
import br.com.caelum.vraptor.http.MutableRequest;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VRaptorRequest
extends HttpServletRequestWrapper
implements MutableRequest {
    private static final Logger logger = LoggerFactory.getLogger(VRaptorRequest.class);
    private final Hashtable<String, String[]> extraParameters = new Hashtable();

    public VRaptorRequest(HttpServletRequest request) {
        super(request);
    }

    public String getParameter(String name) {
        if (this.extraParameters.containsKey(name)) {
            Object[] values = this.extraParameters.get(name);
            if (values.length == 1) {
                return values[0];
            }
            return Arrays.toString(values);
        }
        return super.getParameter(name);
    }

    public Enumeration getParameterNames() {
        return new IteratorToEnumerationAdapter(this.getParameterMap().keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        if (this.extraParameters.containsKey(name)) {
            return this.extraParameters.get(name);
        }
        return super.getParameterValues(name);
    }

    public Map getParameterMap() {
        HashMap<String, String[]> complete = new HashMap<String, String[]>(super.getParameterMap());
        complete.putAll(this.extraParameters);
        return complete;
    }

    public void setParameter(String key, String ... value) {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting {} with {}", (Object)key, (Object)Arrays.toString(value));
        }
        this.extraParameters.put(key, value);
    }

    public String toString() {
        return String.format("[VRaptorRequest %s]", this.getRequest());
    }
}

