/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.asm;

import br.com.caelum.vraptor.asm.ClassWriter;
import br.com.caelum.vraptor.asm.FieldVisitor;
import br.com.caelum.vraptor.asm.MethodVisitor;
import br.com.caelum.vraptor.asm.Opcodes;
import br.com.caelum.vraptor.http.AbstractTypeCreator;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.http.asm.SignatureConverter;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.vraptor2.Info;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class AsmBasedTypeCreator
extends AbstractTypeCreator
implements Opcodes {
    private static final Logger logger = LoggerFactory.getLogger(AsmBasedTypeCreator.class);
    private static final SignatureConverter CONVERTER = new SignatureConverter();
    private static int classLoadCounter = 0;
    private final ParameterNameProvider provider;
    private static final Map<Class<?>, String> wrappers = new HashMap();

    public AsmBasedTypeCreator(ParameterNameProvider provider) {
        super(provider);
        this.provider = provider;
    }

    @Override
    public Class<?> typeFor(ResourceMethod resourceMethod) {
        int i;
        Method method = resourceMethod.getMethod();
        final String newTypeName = method.getDeclaringClass().getSimpleName().replace('.', '/') + "$" + method.getName() + "$" + Math.abs(method.hashCode()) + "$" + ++classLoadCounter;
        logger.debug("Trying to make class for " + newTypeName);
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 33, newTypeName, null, "java/lang/Object", new String[]{"java/io/Serializable"});
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        StringBuilder valueLists = new StringBuilder();
        Type[] types = method.getGenericParameterTypes();
        Object[] names = this.provider.parameterNamesFor(method);
        for (i = 0; i < names.length; ++i) {
            names[i] = Info.capitalize(names[i]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Parameter names found for creating type are: " + Arrays.toString(names));
        }
        for (i = 0; i < types.length; ++i) {
            Type type = types[i];
            if (type instanceof ParameterizedType) {
                this.parse(cw, (ParameterizedType)type, valueLists, newTypeName, (String)names[i]);
                continue;
            }
            if (type instanceof Class) {
                this.parse(cw, (Class)type, valueLists, newTypeName, (String)names[i]);
                continue;
            }
            if (type instanceof TypeVariable) {
                ParameterizedType superclass = (ParameterizedType)resourceMethod.getResource().getType().getGenericSuperclass();
                this.parse(cw, (Class)superclass.getActualTypeArguments()[0], valueLists, newTypeName, (String)names[i]);
                continue;
            }
            throw new IllegalArgumentException("Unable to identify field " + type + " of type " + type.getClass().getName());
        }
        cw.visitEnd();
        final byte[] bytes = cw.toByteArray();
        ClassLoader loader = new ClassLoader(this.getClass().getClassLoader()){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (name.equals(newTypeName)) {
                    return this.defineClass(newTypeName, bytes, 0, bytes.length);
                }
                return super.loadClass(name);
            }
        };
        try {
            Class<?> found = loader.loadClass(newTypeName);
            if (logger.isDebugEnabled()) {
                logger.debug("Methods: " + Arrays.toString(found.getDeclaredMethods()));
                logger.debug("Fields: " + Arrays.toString(found.getDeclaredFields()));
            }
            return found;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("unable to create type to inject values", e);
        }
    }

    private void parse(ClassWriter cw, ParameterizedType type, StringBuilder valueLists, String newTypeName, String fieldName) {
        String definition = CONVERTER.extractTypeDefinition((Class)type.getRawType());
        String genericDefinition = CONVERTER.extractTypeDefinition(type);
        this.parse(cw, newTypeName, definition, genericDefinition, fieldName, 25, 176);
        if (valueLists.length() != 0) {
            valueLists.append(',');
        }
        valueLists.append(fieldName).append("_");
    }

    private void parse(ClassWriter cw, String newTypeName, String definition, String genericDefinition, String fieldName, int loadKey, int returnKey) {
        if (logger.isDebugEnabled()) {
            logger.debug("Method for field '" + fieldName + "' being defined for type " + definition);
        }
        FieldVisitor fv = cw.visitField(2, fieldName + "_", definition, genericDefinition, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "set" + fieldName, "(" + definition + ")V", genericDefinition == null ? null : "(" + genericDefinition + ")V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(loadKey, 1);
        mv.visitFieldInsn(181, newTypeName, fieldName + "_", definition);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "get" + fieldName, "()" + definition, genericDefinition == null ? null : "()" + genericDefinition, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, newTypeName, fieldName + "_", definition);
        mv.visitInsn(returnKey);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void parse(ClassWriter cw, Class<?> type, StringBuilder valueLists, String newTypeName, String fieldName) {
        String definition = CONVERTER.extractTypeDefinition(type);
        String genericDefinition = null;
        this.parse(cw, newTypeName, definition, genericDefinition, fieldName, this.loadFor(type), this.returnFor(type));
        if (valueLists.length() != 0) {
            valueLists.append(',');
        }
        if (type.isPrimitive()) {
            valueLists.append(this.wrapperCodeFor(type, fieldName + "_"));
        } else {
            valueLists.append(fieldName).append("_");
        }
    }

    private String wrapperCodeFor(Class<?> type, String fieldName) {
        return wrappers.get(type) + fieldName + ")";
    }

    private int returnFor(Class<?> type) {
        if (type.equals(Double.TYPE)) {
            return 175;
        }
        if (type.equals(Long.TYPE)) {
            return 173;
        }
        if (type.equals(Float.TYPE)) {
            return 174;
        }
        return type.isPrimitive() ? 172 : 176;
    }

    private int loadFor(Class<?> type) {
        if (type.equals(Double.TYPE)) {
            return 24;
        }
        if (type.equals(Float.TYPE)) {
            return 23;
        }
        if (type.equals(Long.TYPE)) {
            return 22;
        }
        return type.isPrimitive() ? 21 : 25;
    }

    static {
        wrappers.put(Integer.TYPE, "Integer.valueOf(");
        wrappers.put(Boolean.TYPE, "Boolean.valueOf(");
        wrappers.put(Short.TYPE, "Short.valueOf(");
        wrappers.put(Long.TYPE, "Long.valueOf(");
        wrappers.put(Double.TYPE, "Double.valueOf(");
        wrappers.put(Float.TYPE, "Float.valueOf(");
        wrappers.put(Character.TYPE, "Character.valueOf(");
    }
}

