/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.asm;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SignatureConverter {
    private static final Map<Class<?>, String> WRAPPERS = new HashMap();

    SignatureConverter() {
    }

    String wrapperFor(Class<?> type) {
        return WRAPPERS.get(type);
    }

    String extractTypeDefinition(Class<?> type) {
        if (type.isArray()) {
            return "[" + this.extractTypeDefinition(type.getComponentType());
        }
        if (type.isPrimitive()) {
            return WRAPPERS.get(type);
        }
        return 'L' + type.getName().replace('.', '/') + ';';
    }

    String extractTypeDefinition(ParameterizedType type) {
        Type[] types;
        Type raw = type.getRawType();
        String name = this.extractTypeDefinition((Class)raw);
        name = name.substring(0, name.length() - 1) + "<";
        for (Type t : types = type.getActualTypeArguments()) {
            name = name + this.extractTypeDefinition((Class)t);
        }
        return name + ">;";
    }

    static {
        WRAPPERS.put(Boolean.TYPE, "Z");
        WRAPPERS.put(Integer.TYPE, "I");
        WRAPPERS.put(Short.TYPE, "S");
        WRAPPERS.put(Long.TYPE, "J");
        WRAPPERS.put(Double.TYPE, "D");
        WRAPPERS.put(Float.TYPE, "F");
        WRAPPERS.put(Byte.TYPE, "B");
        WRAPPERS.put(Character.TYPE, "C");
    }
}

