/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.ognl;

import br.com.caelum.vraptor.http.ognl.EmptyElementsRemoval;
import br.com.caelum.vraptor.http.ognl.ReflectionBasedNullHandler;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.vraptor2.Info;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import ognl.ArrayPropertyAccessor;
import ognl.OgnlContext;
import ognl.OgnlException;

public class ArrayAccessor
extends ArrayPropertyAccessor {
    public Object getProperty(Map context, Object target, Object object) throws OgnlException {
        try {
            return super.getProperty(context, target, object);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public void setProperty(Map context, Object array, Object key, Object value) throws OgnlException {
        int index = (Integer)key;
        int length = Array.getLength(array);
        if (length <= index) {
            array = this.copyOf(array, index, length);
            OgnlContext ctx = (OgnlContext)context;
            String fieldName = ctx.getCurrentEvaluation().getPrevious().getNode().toString();
            Object origin = ctx.getCurrentEvaluation().getPrevious().getSource();
            Method setter = ReflectionBasedNullHandler.findMethod(origin.getClass(), "set" + Info.capitalize(fieldName), origin.getClass(), null);
            Container container = (Container)context.get(Container.class);
            EmptyElementsRemoval removal = container.instanceFor(EmptyElementsRemoval.class);
            removal.add(array, setter, origin);
            try {
                setter.invoke(origin, array);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        super.setProperty(context, array, key, value);
    }

    private Object copyOf(Object array, int desiredLength, int currentLength) {
        int i;
        Object newArray = Array.newInstance(array.getClass().getComponentType(), desiredLength + 1);
        for (i = 0; i < currentLength; ++i) {
            Array.set(newArray, i, Array.get(array, i));
        }
        for (i = currentLength; i < desiredLength; ++i) {
            Array.set(newArray, i, null);
        }
        array = newArray;
        return array;
    }
}

