/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.ognl;

import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.http.InvalidParameterException;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.http.ParametersProvider;
import br.com.caelum.vraptor.http.TypeCreator;
import br.com.caelum.vraptor.http.ognl.ArrayAccessor;
import br.com.caelum.vraptor.http.ognl.EmptyElementsRemoval;
import br.com.caelum.vraptor.http.ognl.ListAccessor;
import br.com.caelum.vraptor.http.ognl.ReflectionBasedNullHandler;
import br.com.caelum.vraptor.http.ognl.VRaptorConvertersAdapter;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.validator.ValidationMessage;
import br.com.caelum.vraptor.validator.annotation.ValidationException;
import br.com.caelum.vraptor.vraptor2.Info;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import ognl.MethodFailedException;
import ognl.NoSuchPropertyException;
import ognl.NullHandler;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import ognl.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RequestScoped
public class OgnlParametersProvider
implements ParametersProvider {
    private final TypeCreator creator;
    private final Container container;
    private final Converters converters;
    private final ParameterNameProvider provider;
    private static final Logger logger = LoggerFactory.getLogger(OgnlParametersProvider.class);
    private final HttpServletRequest request;
    private final EmptyElementsRemoval removal;

    public OgnlParametersProvider(TypeCreator creator, Container container, Converters converters, ParameterNameProvider provider, HttpServletRequest request, EmptyElementsRemoval removal) {
        this.creator = creator;
        this.container = container;
        this.converters = converters;
        this.provider = provider;
        this.request = request;
        this.removal = removal;
        OgnlRuntime.setNullHandler(Object.class, (NullHandler)new ReflectionBasedNullHandler());
        OgnlRuntime.setPropertyAccessor(List.class, (PropertyAccessor)new ListAccessor());
        OgnlRuntime.setPropertyAccessor(Object[].class, (PropertyAccessor)new ArrayAccessor());
    }

    @Override
    public Object[] getParametersFor(ResourceMethod method, List<Message> errors, ResourceBundle bundle) {
        Object root = this.createRoot(method, errors, bundle);
        this.removal.removeExtraElements();
        Type[] types = method.getMethod().getGenericParameterTypes();
        Object[] result = new Object[types.length];
        String[] names = this.provider.parameterNamesFor(method.getMethod());
        for (int i = 0; i < types.length; ++i) {
            try {
                result[i] = root.getClass().getMethod("get" + Info.capitalize(names[i]), new Class[0]).invoke(root, new Object[0]);
                continue;
            }
            catch (InvocationTargetException e) {
                throw new InvalidParameterException("unable to retrieve values to invoke method", e.getCause());
            }
            catch (Exception e) {
                throw new InvalidParameterException("unable to retrieve values to invoke method", e);
            }
        }
        return result;
    }

    private Object createRoot(ResourceMethod method, List<Message> errors, ResourceBundle bundle) {
        return this.createViaOgnl(method, errors, bundle);
    }

    private Object createViaOgnl(ResourceMethod method, List<Message> errors, ResourceBundle bundle) {
        Object root;
        Class<?> type = this.creator.typeFor(method);
        try {
            root = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new InvalidParameterException("unable to instantiate type" + type.getName(), ex);
        }
        OgnlContext context = (OgnlContext)Ognl.createDefaultContext(root);
        context.setTraceEvaluations(true);
        context.put(Container.class, (Object)this.container);
        VRaptorConvertersAdapter adapter = new VRaptorConvertersAdapter(this.converters, bundle);
        Ognl.setTypeConverter((Map)context, (TypeConverter)adapter);
        Enumeration enumeration = this.request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Object[] values = this.request.getParameterValues(key);
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Applying " + key + " with " + Arrays.toString(values));
                }
                Ognl.setValue((String)key, (Map)context, root, (Object)(values.length == 1 ? values[0] : values));
            }
            catch (ConversionError ex) {
                errors.add(new ValidationMessage(ex.getMessage(), key));
            }
            catch (MethodFailedException e) {
                Throwable cause = e.getCause();
                if (cause.getClass().isAnnotationPresent(ValidationException.class)) {
                    errors.add(new ValidationMessage(cause.getLocalizedMessage(), key));
                    continue;
                }
                throw new InvalidParameterException("unable to parse expression '" + key + "'", e);
            }
            catch (NoSuchPropertyException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("cant find property for expression {} ignoring", (Object)key);
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("cant find property for expression " + key + ", ignoring. Reason:", (Throwable)ex);
            }
            catch (OgnlException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("unable to parse expression '" + key + "'", (Throwable)e);
            }
        }
        return root;
    }
}

