/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.ognl;

import br.com.caelum.vraptor.http.InvalidParameterException;
import br.com.caelum.vraptor.http.ognl.GenericNullHandler;
import br.com.caelum.vraptor.http.ognl.ListNullHandler;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.vraptor2.Info;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import ognl.ObjectNullHandler;
import ognl.OgnlContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionBasedNullHandler
extends ObjectNullHandler {
    private final ListNullHandler list = new ListNullHandler();
    private final GenericNullHandler generic = new GenericNullHandler();

    public Object nullPropertyValue(Map context, Object target, Object property) {
        OgnlContext ctx = (OgnlContext)context;
        int indexInParent = ctx.getCurrentEvaluation().getNode().getIndexInParent();
        int maxIndex = ctx.getRootEvaluation().getNode().jjtGetNumChildren() - 1;
        if (indexInParent == -1 || indexInParent >= maxIndex) {
            return null;
        }
        try {
            Class baseType;
            Container container = (Container)context.get(Container.class);
            if (target instanceof List) {
                return this.list.instantiate(container, target, property, ctx.getCurrentEvaluation().getPrevious());
            }
            String propertyCapitalized = Info.capitalize((String)property);
            Method getter = ReflectionBasedNullHandler.findMethod(target.getClass(), "get" + propertyCapitalized, target.getClass(), null);
            Type returnType = getter.getGenericReturnType();
            if (returnType instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)returnType;
                returnType = paramType.getRawType();
            }
            Object instance = (baseType = (Class)returnType).isArray() ? this.instantiateArray(baseType) : this.generic.instantiate(baseType, container);
            Method setter = ReflectionBasedNullHandler.findMethod(target.getClass(), "set" + propertyCapitalized, target.getClass(), getter.getReturnType());
            setter.invoke(target, instance);
            return instance;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidParameterException("Unable to find the correct constructor", e);
        }
    }

    private Object instantiateArray(Class<?> baseType) {
        return Array.newInstance(baseType.getComponentType(), 0);
    }

    static <P> Method findMethod(Class<?> type, String name, Class<?> baseType, Class<P> parameterType) {
        Method[] methods;
        for (Method method : methods = type.getDeclaredMethods()) {
            if (!method.getName().equals(name) || parameterType != null && (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(parameterType))) continue;
            return method;
        }
        if (type.equals(Object.class)) {
            throw new IllegalArgumentException("Unable to find method for " + name + " @ " + baseType.getName());
        }
        return ReflectionBasedNullHandler.findMethod(type.getSuperclass(), name, type, parameterType);
    }
}

