/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.eval.Evaluator;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.route.ParametersControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultParametersControl
implements ParametersControl {
    private final Logger logger = LoggerFactory.getLogger(DefaultParametersControl.class);
    private final List<String> parameters = new ArrayList<String>();
    private final Pattern pattern;
    private final String originalPattern;

    public DefaultParametersControl(String originalPattern, Map<String, String> parameterPatterns) {
        this.originalPattern = originalPattern;
        this.pattern = this.compilePattern(originalPattern, parameterPatterns);
    }

    public DefaultParametersControl(String originalPattern) {
        this(originalPattern, Collections.emptyMap());
    }

    private Pattern compilePattern(String originalPattern, Map<String, String> parameterPatterns) {
        HashMap<String, String> parameters = new HashMap<String, String>(parameterPatterns);
        Matcher matcher = Pattern.compile("\\{([^\\}]+?)\\}").matcher(originalPattern);
        while (matcher.find()) {
            String defaultPattern;
            String value = matcher.group(1);
            String string = defaultPattern = value.endsWith("*") ? ".*" : "[^/]*";
            if (!parameters.containsKey(value)) {
                parameters.put(value, defaultPattern);
            }
            this.parameters.add(value.replace("*", ""));
        }
        String patternUri = originalPattern;
        for (Map.Entry parameter : parameters.entrySet()) {
            patternUri = patternUri.replace("{" + (String)parameter.getKey() + "}", "(" + (String)parameter.getValue() + ")");
        }
        this.logger.debug("For " + originalPattern + " retrieved " + patternUri + " with " + parameters);
        return Pattern.compile(patternUri);
    }

    @Override
    public String fillUri(Object params) {
        String base = this.originalPattern.replaceAll("\\.\\*", "");
        for (String key : this.parameters) {
            Object result = new Evaluator().get(params, key);
            base = base.replaceAll("\\{" + key + "\\*?\\}", result == null ? "" : result.toString());
        }
        return base;
    }

    @Override
    public boolean matches(String uri) {
        return this.pattern.matcher(uri).matches();
    }

    @Override
    public void fillIntoRequest(String uri, MutableRequest request) {
        Matcher m = this.pattern.matcher(uri);
        m.matches();
        for (int i = 1; i <= m.groupCount(); ++i) {
            String name = this.parameters.get(i - 1);
            request.setParameter(name, m.group(i));
        }
    }

    @Override
    public String apply(String[] values) {
        String regex = "\\{.*?\\}";
        String result = this.originalPattern;
        for (int i = 0; i < values.length; ++i) {
            result = result.replaceFirst(regex, values[i].replaceAll("\\$", "\\\\\\$"));
        }
        return result.toString();
    }
}

