/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.route.ParametersControl;
import br.com.caelum.vraptor.http.route.Route;
import br.com.caelum.vraptor.resource.DefaultResourceClass;
import br.com.caelum.vraptor.resource.DefaultResourceMethod;
import br.com.caelum.vraptor.resource.HttpMethod;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.util.Stringnifier;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedMethodStrategy
implements Route {
    private final ResourceMethod resourceMethod;
    private final EnumSet<HttpMethod> methods;
    private final ParametersControl parameters;
    private final int priority;
    private final String originalUri;

    public FixedMethodStrategy(String originalUri, Class<?> type, Method method, Set<HttpMethod> methods, ParametersControl control, int priority) {
        this.originalUri = originalUri;
        this.methods = methods.isEmpty() ? EnumSet.allOf(HttpMethod.class) : EnumSet.copyOf(methods);
        this.parameters = control;
        this.resourceMethod = new DefaultResourceMethod(new DefaultResourceClass(type), method);
        this.priority = priority;
    }

    @Override
    public boolean canHandle(Class<?> type, Method method) {
        return type.equals(this.resourceMethod.getResource().getType()) && method.equals(this.resourceMethod.getMethod());
    }

    @Override
    public ResourceMethod resourceMethod(MutableRequest request, String uri) {
        this.parameters.fillIntoRequest(uri, request);
        return this.resourceMethod;
    }

    @Override
    public EnumSet<HttpMethod> allowedMethods() {
        return this.methods;
    }

    @Override
    public boolean canHandle(String uri) {
        return this.parameters.matches(uri);
    }

    @Override
    public String urlFor(Class<?> type, Method m, Object params) {
        return this.parameters.fillUri(params);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public String toString() {
        return String.format("[FixedMethodStrategy: %-65s %-70s %s]", this.originalUri, Stringnifier.simpleNameFor(this.resourceMethod.getMethod()), this.methods.size() == HttpMethod.values().length ? "ALL" : this.methods);
    }
}

