/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.Path;
import br.com.caelum.vraptor.http.route.Route;
import br.com.caelum.vraptor.http.route.RouteBuilder;
import br.com.caelum.vraptor.http.route.RoutesParser;
import br.com.caelum.vraptor.http.route.TypeFinder;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.resource.HttpMethod;
import br.com.caelum.vraptor.resource.ResourceClass;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class PathAnnotationRoutesParser
implements RoutesParser {
    private final Proxifier proxifier;
    private final TypeFinder finder;

    public PathAnnotationRoutesParser(Proxifier proxifier, TypeFinder finder) {
        this.proxifier = proxifier;
        this.finder = finder;
    }

    @Override
    public List<Route> rulesFor(ResourceClass resource) {
        Class<?> baseType = resource.getType();
        return this.registerRulesFor(baseType);
    }

    protected List<Route> registerRulesFor(Class<?> baseType) {
        ArrayList<Route> routes = new ArrayList<Route>();
        for (Method javaMethod : baseType.getMethods()) {
            String[] uris;
            if (!this.isEligible(javaMethod)) continue;
            for (String uri : uris = this.getURIsFor(javaMethod, baseType)) {
                RouteBuilder rule = new RouteBuilder(this.proxifier, this.finder, uri);
                for (HttpMethod m : HttpMethod.values()) {
                    if (!javaMethod.isAnnotationPresent(m.getAnnotation())) continue;
                    rule.with(m);
                }
                if (javaMethod.isAnnotationPresent(Path.class)) {
                    rule.withPriority(javaMethod.getAnnotation(Path.class).priority());
                }
                rule.is(baseType, javaMethod);
                routes.add(rule.build());
            }
        }
        return routes;
    }

    protected boolean isEligible(Method javaMethod) {
        return Modifier.isPublic(javaMethod.getModifiers()) && !Modifier.isStatic(javaMethod.getModifiers()) && !javaMethod.isBridge() && !javaMethod.getDeclaringClass().equals(Object.class);
    }

    protected String[] getURIsFor(Method javaMethod, Class<?> type) {
        if (javaMethod.isAnnotationPresent(Path.class)) {
            String[] uris = javaMethod.getAnnotation(Path.class).value();
            if (uris.length == 0) {
                throw new IllegalArgumentException("You must specify at least one path on @Path at " + javaMethod);
            }
            this.fixURIs(type, uris);
            return uris;
        }
        return new String[]{this.defaultUriFor(this.extractControllerNameFrom(type), javaMethod.getName())};
    }

    protected void fixURIs(Class<?> type, String[] uris) {
        String prefix = this.extractPrefix(type);
        for (int i = 0; i < uris.length; ++i) {
            uris[i] = "".equals(prefix) ? this.fixLeadingSlash(uris[i]) : ("".equals(uris[i]) ? prefix : this.removeTrailingSlash(prefix) + this.fixLeadingSlash(uris[i]));
        }
    }

    protected String removeTrailingSlash(String prefix) {
        return prefix.replaceFirst("/$", "");
    }

    protected String extractPrefix(Class<?> type) {
        if (type.isAnnotationPresent(Path.class)) {
            String[] uris = type.getAnnotation(Path.class).value();
            if (uris.length != 1) {
                throw new IllegalArgumentException("You must specify exactly one path on @Path at " + type);
            }
            return this.fixLeadingSlash(uris[0]);
        }
        return "";
    }

    private String fixLeadingSlash(String uri) {
        if (!uri.startsWith("/")) {
            return "/" + uri;
        }
        return uri;
    }

    protected String extractControllerNameFrom(Class<?> type) {
        String prefix = this.extractPrefix(type);
        if ("".equals(prefix)) {
            String baseName = this.lowerFirstCharacter(type.getSimpleName());
            if (baseName.endsWith("Controller")) {
                return "/" + baseName.substring(0, baseName.lastIndexOf("Controller"));
            }
            return "/" + baseName;
        }
        return prefix;
    }

    protected String defaultUriFor(String controllerName, String methodName) {
        return controllerName + "/" + methodName;
    }

    protected String lowerFirstCharacter(String baseName) {
        return baseName.toLowerCase().substring(0, 1) + baseName.substring(1, baseName.length());
    }
}

