/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.http.route.IllegalRouteException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternBasedType {
    private final List<String> parameters = new ArrayList<String>();
    private final Pattern pattern;
    private final String originalPattern;

    public PatternBasedType(String pattern) {
        this.originalPattern = pattern;
        String finalUri = "";
        String patternUri = "";
        String paramName = "";
        boolean ignore = false;
        for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == '{') {
                ignore = true;
                patternUri = patternUri + "(";
                continue;
            }
            if (pattern.charAt(i) == '}') {
                ignore = false;
                finalUri = finalUri + ".*";
                patternUri = patternUri + ".*)";
                this.parameters.add(paramName);
                paramName = "";
                continue;
            }
            if (!ignore) {
                patternUri = patternUri + pattern.charAt(i);
                finalUri = finalUri + pattern.charAt(i);
                continue;
            }
            paramName = paramName + pattern.charAt(i);
        }
        if (ignore) {
            throw new IllegalRouteException("Illegal route contains invalid pattern: " + this.originalPattern);
        }
        this.pattern = Pattern.compile(patternUri);
    }

    public boolean matches(String name) {
        return this.pattern.matcher(name).matches();
    }

    public String apply(String key, String value) {
        return this.originalPattern.replace("{" + key + "}", value);
    }

    public String extract(String paramName, String from) {
        Matcher matcher = this.pattern.matcher(from);
        matcher.matches();
        return matcher.group(this.parameters.indexOf(paramName) + 1);
    }

    public String toString() {
        return "[PatternBasedType" + this.originalPattern + " ]";
    }
}

