/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.http.route.Route;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityRoutesList
implements Collection<Route> {
    private final SortedMap<Integer, List<Route>> map = new TreeMap<Integer, List<Route>>();
    private List<Route> cache;

    private List<Route> getFullList() {
        if (this.cache == null) {
            this.cache = new LinkedList<Route>();
            for (Map.Entry<Integer, List<Route>> entry : this.map.entrySet()) {
                this.cache.addAll((Collection<Route>)entry.getValue());
            }
        }
        return this.cache;
    }

    private List<Route> getListFor(Route e) {
        if (!this.map.containsKey(e.getPriority())) {
            this.map.put(e.getPriority(), new LinkedList());
        }
        List list = (List)this.map.get(e.getPriority());
        return list;
    }

    @Override
    public boolean add(Route e) {
        this.cache = null;
        return this.getListFor(e).add(e);
    }

    @Override
    public boolean addAll(Collection<? extends Route> c) {
        for (Route route : c) {
            this.add(route);
        }
        return true;
    }

    @Override
    public void clear() {
        this.cache = null;
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.getFullList().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getFullList().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.getFullList().isEmpty();
    }

    @Override
    public Iterator<Route> iterator() {
        return this.getFullList().iterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.getFullList().size();
    }

    @Override
    public Object[] toArray() {
        return this.getFullList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getFullList().toArray(a);
    }
}

