/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.http.route.DefaultParametersControl;
import br.com.caelum.vraptor.http.route.FixedMethodStrategy;
import br.com.caelum.vraptor.http.route.IllegalRouteException;
import br.com.caelum.vraptor.http.route.NoStrategy;
import br.com.caelum.vraptor.http.route.ParametersControl;
import br.com.caelum.vraptor.http.route.PatternBasedStrategy;
import br.com.caelum.vraptor.http.route.PatternBasedType;
import br.com.caelum.vraptor.http.route.Route;
import br.com.caelum.vraptor.http.route.TypeFinder;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.SuperMethod;
import br.com.caelum.vraptor.resource.HttpMethod;
import br.com.caelum.vraptor.util.Stringnifier;
import com.google.common.base.Joiner;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteBuilder {
    private final Set<HttpMethod> supportedMethods = new HashSet<HttpMethod>();
    private final Proxifier proxifier;
    private static final Logger logger = LoggerFactory.getLogger(RouteBuilder.class);
    private final String originalUri;
    private Route strategy = new NoStrategy();
    private int priority = Integer.MAX_VALUE;
    private final ParameterControlBuilder builder;
    private final TypeFinder finder;

    public RouteBuilder(Proxifier proxifier, TypeFinder finder, String uri) {
        this.proxifier = proxifier;
        this.finder = finder;
        this.originalUri = uri = uri.replaceAll("\\*[^\\}]", ".\\*?");
        this.builder = new ParameterControlBuilder();
    }

    public ParameterControlBuilder withParameter(String name) {
        return this.builder.withParameter(name);
    }

    public <T> T is(final Class<T> type) {
        MethodInvocation handler = new MethodInvocation<T>(){

            @Override
            public Object intercept(Object proxy, Method method, Object[] args, SuperMethod superMethod) {
                boolean alreadySetTheStrategy;
                boolean bl = alreadySetTheStrategy = !RouteBuilder.this.strategy.getClass().equals(NoStrategy.class);
                if (alreadySetTheStrategy) {
                    return null;
                }
                RouteBuilder.this.is(type, method);
                return null;
            }
        };
        return this.proxifier.proxify(type, handler);
    }

    public void is(PatternBasedType type, PatternBasedType method) {
        this.strategy = new PatternBasedStrategy(this.builder.build(), type, method, this.supportedMethods, this.priority);
    }

    public void is(Class<?> type, Method method) {
        this.addParametersInfo(method);
        this.strategy = new FixedMethodStrategy(this.originalUri, type, method, this.supportedMethods, this.builder.build(), this.priority);
        logger.info(String.format("%-50s%s -> %10s", this.originalUri, this.supportedMethods.isEmpty() ? "[ALL]" : this.supportedMethods, Stringnifier.simpleNameFor(method)));
    }

    private void addParametersInfo(Method method) {
        String[] parameters = this.extractParameters(this.originalUri);
        Map<String, Class<?>> types = this.finder.getParameterTypes(method, parameters);
        for (Map.Entry<String, Class<?>> entry : types.entrySet()) {
            if (this.builder.parameters.containsKey(entry.getKey())) continue;
            this.builder.withParameter(entry.getKey()).ofType(entry.getValue());
        }
        for (String parameter : parameters) {
            String[] split = parameter.split(":");
            if (split.length < 2 || this.builder.parameters.containsKey(parameter)) continue;
            this.builder.withParameter(parameter).matching(split[1]);
        }
    }

    private String[] extractParameters(String uri) {
        String startUntilOpenBraces = "^[^\\{]*\\{";
        String or = "|";
        String betweenBraces = "\\*?\\}[^\\{]*\\{";
        String closeBracesUntilEnd = "\\*?\\}[^\\{\\}]*$";
        return uri.split(startUntilOpenBraces + or + betweenBraces + or + closeBracesUntilEnd);
    }

    public RouteBuilder with(HttpMethod method) {
        this.supportedMethods.add(method);
        return this;
    }

    public RouteBuilder withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public Route build() {
        if (this.strategy instanceof NoStrategy) {
            throw new IllegalRouteException("You have created a route, but did not specify any method to be invoked: " + this.originalUri);
        }
        return this.strategy;
    }

    public String toString() {
        if (this.supportedMethods.isEmpty()) {
            return String.format("<< Route: %s => %s >>", this.originalUri, this.strategy.toString());
        }
        return String.format("<< Route: %s %s=> %s >>", this.originalUri, this.supportedMethods, this.strategy.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ParameterControlBuilder {
        private final Map<String, String> parameters = new HashMap<String, String>();
        private String name;

        private ParameterControlBuilder withParameter(String name) {
            this.name = name;
            return this;
        }

        public RouteBuilder ofType(Class<?> type) {
            this.parameters.put(this.name, this.regexFor(type));
            return RouteBuilder.this;
        }

        private String regexFor(Class<?> type) {
            if (Arrays.asList(Integer.class, Long.class, Integer.TYPE, Long.TYPE, BigInteger.class, Character.TYPE, Character.class, Short.class, Short.TYPE).contains(type)) {
                return "-?\\d+";
            }
            if (Arrays.asList(Double.class, BigDecimal.class, Double.TYPE, Float.class, Float.TYPE).contains(type)) {
                return "-?\\d*\\.?\\d+";
            }
            if (Arrays.asList(Boolean.class, Boolean.TYPE).contains(type)) {
                return "true|false";
            }
            if (Enum.class.isAssignableFrom(type)) {
                return Joiner.on((String)"|").join((Object[])type.getEnumConstants());
            }
            return "[^/]+";
        }

        public RouteBuilder matching(String regex) {
            this.parameters.put(this.name, regex);
            return RouteBuilder.this;
        }

        private ParametersControl build() {
            return new DefaultParametersControl(RouteBuilder.this.originalUri, this.parameters);
        }
    }
}

