/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.util.StringUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;

@ApplicationScoped
public class DefaultTypeNameExtractor
implements TypeNameExtractor {
    public String nameFor(Type generic) {
        if (generic instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)generic;
            Class raw = (Class)type.getRawType();
            if (Collection.class.isAssignableFrom(raw)) {
                return this.nameFor(type.getActualTypeArguments()[0]) + "List";
            }
            return this.nameFor(raw);
        }
        if (generic instanceof WildcardType) {
            WildcardType wild = (WildcardType)generic;
            if (wild.getLowerBounds().length != 0) {
                return this.nameFor(wild.getLowerBounds()[0]);
            }
            return this.nameFor(wild.getUpperBounds()[0]);
        }
        if (generic instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)generic;
            return StringUtils.lowercaseFirst(variable.getName());
        }
        Class raw = (Class)generic;
        if (raw.isArray()) {
            return this.nameFor(raw.getComponentType()) + "List";
        }
        String name = raw.getSimpleName();
        return StringUtils.lowercaseFirst(name);
    }
}

