/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.Consumes;
import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.deserialization.Deserializer;
import br.com.caelum.vraptor.deserialization.Deserializers;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.view.Status;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class DeserializingInterceptor
implements Interceptor {
    private final HttpServletRequest request;
    private final Deserializers deserializers;
    private final MethodInfo methodInfo;
    private final Container container;
    private final Status status;

    public DeserializingInterceptor(HttpServletRequest servletRequest, Deserializers deserializers, MethodInfo methodInfo, Container container, Status status) {
        this.request = servletRequest;
        this.deserializers = deserializers;
        this.methodInfo = methodInfo;
        this.container = container;
        this.status = status;
    }

    public boolean accepts(ResourceMethod method) {
        return method.containsAnnotation(Consumes.class);
    }

    public void intercept(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        Consumes consumesAnnotation = method.getMethod().getAnnotation(Consumes.class);
        List<String> supported = Arrays.asList(consumesAnnotation.value());
        String contentType = this.request.getContentType();
        if (!supported.isEmpty() && !supported.contains(contentType)) {
            this.unsupported(String.format("Request with media type [%s]. Expecting one of %s.", contentType, supported));
            return;
        }
        try {
            Deserializer deserializer = this.deserializers.deserializerFor(contentType, this.container);
            if (deserializer == null) {
                this.unsupported(String.format("Unable to handle media type [%s]: no deserializer found.", contentType));
                return;
            }
            Object[] deserialized = deserializer.deserialize((InputStream)this.request.getInputStream(), method);
            Object[] parameters = this.methodInfo.getParameters();
            for (int i = 0; i < deserialized.length; ++i) {
                if (deserialized[i] == null) continue;
                parameters[i] = deserialized[i];
            }
            stack.next(method, resourceInstance);
        }
        catch (IOException e) {
            throw new InterceptionException(e);
        }
    }

    private void unsupported(String message) {
        this.status.unsupportedMediaType(message);
    }
}

