/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Validator;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.util.Stringnifier;
import br.com.caelum.vraptor.validator.ValidationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteMethodInterceptor
implements Interceptor {
    private final MethodInfo info;
    private final Validator validator;
    private static final Logger log = LoggerFactory.getLogger(ExecuteMethodInterceptor.class);

    public ExecuteMethodInterceptor(MethodInfo info, Validator validator) {
        this.info = info;
        this.validator = validator;
    }

    public void intercept(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        try {
            Method reflectionMethod = method.getMethod();
            Object[] parameters = this.info.getParameters();
            log.debug("Invoking {}", (Object)Stringnifier.simpleNameFor(reflectionMethod));
            Object result = reflectionMethod.invoke(resourceInstance, parameters);
            if (this.validator.hasErrors()) {
                throw new InterceptionException("There are validation errors and you forgot to specify where to go. Please add in your method something like:\nvalidator.onErrorUse(page()).of(AnyController.class).anyMethod();\nor any view that you like.\nIf you didn't add any validation error, it is possible that a conversion error had happened.");
            }
            if (reflectionMethod.getReturnType().equals(Void.TYPE)) {
                this.info.setResult("ok");
            } else {
                this.info.setResult(result);
            }
            stack.next(method, resourceInstance);
        }
        catch (IllegalArgumentException e) {
            throw new InterceptionException(e);
        }
        catch (IllegalAccessException e) {
            throw new InterceptionException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ValidationException) {
                log.trace("swallowing {}", cause);
            }
            throw new InterceptionException("an exception was raised while executing resource method", cause);
        }
    }

    public boolean accepts(ResourceMethod method) {
        return true;
    }
}

