/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.http.MutableResponse;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashInterceptor
implements Interceptor {
    static final String FLASH_INCLUDED_PARAMETERS = "br.com.caelum.vraptor.flash.parameters";
    private static final Logger LOGGER = LoggerFactory.getLogger(FlashInterceptor.class);
    private final HttpSession session;
    private final Result result;
    private final MutableResponse response;

    public FlashInterceptor(HttpSession session, Result result, MutableResponse response) {
        this.session = session;
        this.result = result;
        this.response = response;
    }

    public boolean accepts(ResourceMethod method) {
        return true;
    }

    public void intercept(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        Map parameters = (Map)this.session.getAttribute(FLASH_INCLUDED_PARAMETERS);
        if (parameters != null) {
            this.session.removeAttribute(FLASH_INCLUDED_PARAMETERS);
            for (Map.Entry parameter : parameters.entrySet()) {
                this.result.include((String)parameter.getKey(), parameter.getValue());
            }
        }
        this.response.addRedirectListener(new MutableResponse.RedirectListener(){

            public void beforeRedirect() {
                try {
                    Map<String, Object> included = FlashInterceptor.this.result.included();
                    if (!included.isEmpty()) {
                        FlashInterceptor.this.session.setAttribute(FlashInterceptor.FLASH_INCLUDED_PARAMETERS, included);
                    }
                }
                catch (IllegalStateException e) {
                    LOGGER.warn("HTTP Session was invalidated. It is not possible to include Result parameters on Flash Scope", (Throwable)e);
                }
            }
        });
        stack.next(method, resourceInstance);
    }
}

