/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Validator;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.core.Localization;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.http.ParametersProvider;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.validator.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParametersInstantiatorInterceptor
implements Interceptor {
    private final ParametersProvider provider;
    private final MethodInfo parameters;
    private static final Logger logger = LoggerFactory.getLogger(ParametersInstantiatorInterceptor.class);
    private final Validator validator;
    private final Localization localization;
    private final List<Message> errors = new ArrayList<Message>();
    private final HttpSession session;
    public static final String FLASH_PARAMETERS = "_vraptor_flash_parameters";

    public ParametersInstantiatorInterceptor(ParametersProvider provider, MethodInfo parameters, Validator validator, Localization localization, HttpSession session) {
        this.provider = provider;
        this.parameters = parameters;
        this.validator = validator;
        this.localization = localization;
        this.session = session;
    }

    public boolean accepts(ResourceMethod method) {
        return true;
    }

    public void intercept(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        Object[] values = this.getParametersFor(method);
        this.validator.addAll(this.errors);
        if (logger.isDebugEnabled()) {
            logger.debug("Parameter values for " + method + " are " + Arrays.asList(values));
        }
        this.parameters.setParameters(values);
        stack.next(method, resourceInstance);
    }

    private Object[] getParametersFor(ResourceMethod method) {
        Object[] args = (Object[])this.session.getAttribute(FLASH_PARAMETERS);
        if (args == null) {
            return this.provider.getParametersFor(method, this.errors, this.localization.getBundle());
        }
        this.session.removeAttribute(FLASH_PARAMETERS);
        return args;
    }
}

