/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor.download;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.interceptor.download.Download;
import br.com.caelum.vraptor.interceptor.download.FileDownload;
import br.com.caelum.vraptor.interceptor.download.InputStreamDownload;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.resource.ResourceMethod;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class DownloadInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(DownloadInterceptor.class);
    private final HttpServletResponse response;
    private final MethodInfo info;
    private final Result result;

    public DownloadInterceptor(HttpServletResponse response, MethodInfo info, Result result) {
        this.response = response;
        this.info = info;
        this.result = result;
    }

    public boolean accepts(ResourceMethod method) {
        Class<?> type = method.getMethod().getReturnType();
        return InputStream.class.isAssignableFrom(type) || type == File.class || Download.class.isAssignableFrom(type);
    }

    public void intercept(InterceptorStack stack, ResourceMethod method, Object instance) throws InterceptionException {
        logger.debug("Sending a file to the client");
        Object result = this.info.getResult();
        if (result == null) {
            if (this.result.used()) {
                stack.next(method, instance);
                return;
            }
            throw new NullPointerException("You've just returned a Null Download. Consider redirecting to another page/logic");
        }
        try {
            Download download = null;
            if (result instanceof InputStream) {
                InputStream input = (InputStream)result;
                download = new InputStreamDownload(input, null, null);
            } else if (result instanceof File) {
                File file = (File)result;
                download = new FileDownload(file, null, null);
            } else if (result instanceof Download) {
                download = (Download)result;
            }
            ServletOutputStream output = this.response.getOutputStream();
            download.write(this.response);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new InterceptionException(e);
        }
    }
}

