/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor.download;

import br.com.caelum.vraptor.interceptor.download.Download;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class InputStreamDownload
implements Download {
    private final InputStream stream;
    private final String contentType;
    private final String fileName;
    private final boolean doDownload;
    private final long size;

    public InputStreamDownload(InputStream input, String contentType, String fileName) {
        this(input, contentType, fileName, false, 0L);
    }

    public InputStreamDownload(InputStream input, String contentType, String fileName, boolean doDownload, long size) {
        this.stream = input;
        this.size = size;
        this.contentType = contentType;
        this.fileName = fileName;
        this.doDownload = doDownload;
    }

    public void write(HttpServletResponse response) throws IOException {
        int read;
        this.writeDetails(response);
        ServletOutputStream out = response.getOutputStream();
        int bufferSize = 8192;
        byte[] buffer = new byte[bufferSize];
        while ((read = this.stream.read(buffer)) >= 0) {
            out.write(buffer, 0, read);
        }
        this.stream.close();
    }

    void writeDetails(HttpServletResponse response) {
        if (this.contentType != null) {
            String contentDisposition = String.format("%s; filename=%s", this.doDownload ? "attachment" : "inline", this.fileName);
            response.setHeader("Content-disposition", contentDisposition);
            response.setHeader("Content-type", this.contentType);
        }
        if (this.size > 0L) {
            response.setHeader("Content-Length", Long.toString(this.size));
        }
    }
}

