/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor.multipart;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Validator;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.interceptor.multipart.MultipartConfig;
import br.com.caelum.vraptor.interceptor.multipart.MultipartItemsProcessor;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.validator.Validations;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class MultipartInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(MultipartInterceptor.class);
    private final long sizeLimit;
    private final HttpServletRequest request;
    private final MutableRequest parameters;
    private final MultipartConfig config;
    private final Validator validator;

    public MultipartInterceptor(HttpServletRequest request, MutableRequest parameters, MultipartConfig config, Validator validator) throws IOException {
        this.request = request;
        this.parameters = parameters;
        this.validator = validator;
        this.sizeLimit = config.getSizeLimit();
        this.config = config;
    }

    public void intercept(InterceptorStack stack, ResourceMethod method, Object instance) throws InterceptionException {
        List fileItems;
        logger.debug("Trying to parse multipart request.");
        File temporaryDirectory = this.config.getDirectory();
        FileItemFactory factory = this.createFactoryForDiskBasedFileItems(temporaryDirectory);
        ServletFileUpload fileUploadHandler = new ServletFileUpload(factory);
        fileUploadHandler.setSizeMax(this.sizeLimit);
        try {
            fileItems = fileUploadHandler.parseRequest(this.request);
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            this.validator.checking(new Validations(){
                {
                    this.that(false, "upload", "file.limit.exceeded", e.getActualSize(), e.getPermittedSize());
                }
            });
            logger.warn("The file size limit was exceeded.", (Throwable)e);
            stack.next(method, instance);
            return;
        }
        catch (FileUploadException e) {
            logger.warn("There was some problem parsing this multipart request, or someone is not sending a RFC1867 compatible multipart request.", (Throwable)e);
            stack.next(method, instance);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found [" + fileItems.size() + "] attributes in the multipart form submission. Parsing them.");
        }
        new MultipartItemsProcessor(fileItems, this.request, this.parameters).process();
        stack.next(method, instance);
    }

    protected FileItemFactory createFactoryForDiskBasedFileItems(File temporaryDirectory) {
        int thresholdForUsingDiskInsteadOfMemory = (int)this.sizeLimit;
        DiskFileItemFactory factory = new DiskFileItemFactory(thresholdForUsingDiskInsteadOfMemory, temporaryDirectory);
        logger.debug("Using repository [" + factory.getRepository() + "] for file upload");
        return factory;
    }

    public boolean accepts(ResourceMethod method) {
        return FileUploadBase.isMultipartContent((RequestContext)new ServletRequestContext(this.request));
    }
}

