/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor.multipart;

import br.com.caelum.vraptor.http.InvalidParameterException;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.interceptor.multipart.DefaultUploadedFile;
import com.google.common.collect.LinkedListMultimap;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartItemsProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MultipartItemsProcessor.class);
    private final List<FileItem> items;
    private final HttpServletRequest request;
    private final MutableRequest parameters;

    public MultipartItemsProcessor(List<FileItem> items, HttpServletRequest request, MutableRequest parameters) {
        this.items = items;
        this.request = request;
        this.parameters = parameters;
    }

    public void process() {
        LinkedListMultimap params = LinkedListMultimap.create();
        for (FileItem item : this.items) {
            if (item.isFormField()) {
                params.put((Object)item.getFieldName(), (Object)this.getValue(item));
                continue;
            }
            if (MultipartItemsProcessor.notEmpty(item)) {
                try {
                    DefaultUploadedFile fileInformation = new DefaultUploadedFile(item.getInputStream(), item.getName(), item.getContentType());
                    this.parameters.setParameter(item.getFieldName(), item.getName());
                    this.request.setAttribute(item.getName(), (Object)fileInformation);
                    logger.debug("Uploaded file: " + item.getFieldName() + " with " + fileInformation);
                    continue;
                }
                catch (Exception e) {
                    throw new InvalidParameterException("Cant parse uploaded file " + item.getName(), e);
                }
            }
            logger.debug("A file field was empty: " + item.getFieldName());
        }
        for (String paramName : params.keySet()) {
            Collection paramValues = params.get((Object)paramName);
            this.parameters.setParameter(paramName, paramValues.toArray(new String[paramValues.size()]));
        }
    }

    private String getValue(FileItem item) {
        String encoding = this.request.getCharacterEncoding();
        if (encoding != null && !encoding.equals("")) {
            try {
                return item.getString(encoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("Request have an invalid encoding. Ignoring it");
            }
        }
        return item.getString();
    }

    private static boolean notEmpty(FileItem item) {
        return !item.getName().trim().equals("");
    }
}

