/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc;

import br.com.caelum.vraptor.ComponentRegistry;
import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.VRaptorException;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.interceptor.InterceptorRegistry;
import br.com.caelum.vraptor.interceptor.InterceptorSequence;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.StereotypeHandler;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class InterceptorStereotypeHandler
implements StereotypeHandler {
    private static final Logger logger = LoggerFactory.getLogger(InterceptorStereotypeHandler.class);
    private final InterceptorRegistry registry;
    private final ComponentRegistry componentRegistry;

    public InterceptorStereotypeHandler(InterceptorRegistry registry, ComponentRegistry componentRegistry) {
        this.registry = registry;
        this.componentRegistry = componentRegistry;
    }

    @Override
    public Class<? extends Annotation> stereotype() {
        return Intercepts.class;
    }

    @Override
    public void handle(Class<?> type) {
        if (Interceptor.class.isAssignableFrom(type)) {
            this.registerInterceptor(type);
        } else if (InterceptorSequence.class.isAssignableFrom(type)) {
            this.registerInterceptorSequence(type);
        } else {
            throw new VRaptorException("Annotation " + Intercepts.class + " found in " + type + ", but it is neither an Interceptor nor an InterceptorSequence.");
        }
    }

    private void registerInterceptor(Class<?> type) {
        logger.debug("Found interceptor for " + type);
        Class<?> interceptorType = type;
        this.registry.register(interceptorType);
    }

    private void registerInterceptorSequence(Class<?> type) {
        logger.debug("Found interceptor sequence for " + type);
        Class<?> interceptorSequenceType = type;
        this.registry.register(this.parseSequence(interceptorSequenceType));
    }

    private Class<? extends Interceptor>[] parseSequence(Class<? extends InterceptorSequence> type) {
        try {
            Class<? extends Interceptor>[] interceptors;
            InterceptorSequence sequence = type.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Class<? extends Interceptor> interceptor : interceptors = sequence.getSequence()) {
                this.componentRegistry.deepRegister(interceptor);
            }
            return interceptors;
        }
        catch (Exception e) {
            throw new VRaptorException("Problem ocurred while instantiating an interceptor sequence", e);
        }
    }
}

