/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.pico;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.ComponentFactory;
import br.com.caelum.vraptor.ioc.Stereotype;
import br.com.caelum.vraptor.ioc.pico.ComponentFactoryRegistry;
import br.com.caelum.vraptor.ioc.pico.Registrar;
import br.com.caelum.vraptor.ioc.pico.Scanner;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ComponentFactoryRegistrar
implements Registrar {
    private final Logger logger = LoggerFactory.getLogger(ComponentFactoryRegistrar.class);
    private final ComponentFactoryRegistry registry;

    public ComponentFactoryRegistrar(ComponentFactoryRegistry registry) {
        this.registry = registry;
    }

    public void registerFrom(Scanner scanner) {
        this.logger.info("Registering all components that implement ComponentFactory as Pico ComponentAdapters");
        Collection<Class<ComponentFactory>> factoryTypes = scanner.getSubtypesOfWithMetaAnnotation(ComponentFactory.class, Stereotype.class);
        for (Class<ComponentFactory> factoryType : factoryTypes) {
            this.logger.debug("ComponentFactory found: " + factoryType);
            this.registry.register(factoryType);
        }
    }
}

