/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.pico;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.VRaptorException;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.pico.Registrar;
import br.com.caelum.vraptor.ioc.pico.Scanner;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ConverterRegistrar
implements Registrar {
    private final Logger logger = LoggerFactory.getLogger(ConverterRegistrar.class);
    private final Converters converters;

    public ConverterRegistrar(Converters converters) {
        this.converters = converters;
    }

    public void registerFrom(Scanner scanner) {
        this.logger.info("Registering all custom converters annotated with @Convert");
        Collection<Class<?>> converterTypes = scanner.getTypesWithAnnotation(Convert.class);
        for (Class<?> converterType : converterTypes) {
            if (!Converter.class.isAssignableFrom(converterType)) {
                throw new VRaptorException("converter " + converterType + "does not implement Converter");
            }
            this.logger.debug("found converter: " + converterType);
            this.converters.register(converterType);
        }
    }
}

