/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.pico;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.ComponentFactory;
import br.com.caelum.vraptor.ioc.ComponentFactoryIntrospector;
import br.com.caelum.vraptor.ioc.SessionScoped;
import br.com.caelum.vraptor.ioc.pico.ComponentFactoryRegistry;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class DefaultComponentFactoryRegistry
implements ComponentFactoryRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DefaultComponentFactoryRegistry.class);
    private final Map<Class<?>, Class<? extends ComponentFactory>> applicationScoped = new HashMap();
    private final Map<Class<?>, Class<? extends ComponentFactory>> sessionScoped = new HashMap();
    private final Map<Class<?>, Class<? extends ComponentFactory>> requestScoped = new HashMap();
    private ComponentFactoryIntrospector componentFactoryIntrospector = new ComponentFactoryIntrospector();

    @Override
    public void register(Class<? extends ComponentFactory> componentFactoryClass) {
        Class<?> targetType = this.componentFactoryIntrospector.targetTypeForComponentFactory(componentFactoryClass);
        if (componentFactoryClass.isAnnotationPresent(ApplicationScoped.class)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Registering a ComponentFactory for " + targetType.getName() + " in app scope");
            }
            this.applicationScoped.put(targetType, componentFactoryClass);
        } else if (componentFactoryClass.isAnnotationPresent(SessionScoped.class)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Registering a ComponentFactory for " + targetType.getName() + " in session scope");
            }
            this.sessionScoped.put(targetType, componentFactoryClass);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Registering a ComponentFactory for " + targetType.getName() + " in request scope");
            }
            this.requestScoped.put(targetType, componentFactoryClass);
        }
    }

    @Override
    public Map<Class<?>, Class<? extends ComponentFactory>> getApplicationMap() {
        return this.applicationScoped;
    }

    @Override
    public Map<Class<?>, Class<? extends ComponentFactory>> getSessionMap() {
        return this.sessionScoped;
    }

    @Override
    public Map<Class<?>, Class<? extends ComponentFactory>> getRequestMap() {
        return this.requestScoped;
    }
}

