/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.pico;

import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.VRaptorException;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.interceptor.InterceptorRegistry;
import br.com.caelum.vraptor.interceptor.InterceptorSequence;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.pico.Registrar;
import br.com.caelum.vraptor.ioc.pico.Scanner;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class InterceptorRegistrar
implements Registrar {
    private final Logger logger = LoggerFactory.getLogger(InterceptorRegistrar.class);
    private final InterceptorRegistry registry;

    public InterceptorRegistrar(InterceptorRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void registerFrom(Scanner scanner) {
        this.logger.info("Registering all interceptors annotated with @Intercepts");
        Collection<Class<?>> interceptorTypes = scanner.getTypesWithAnnotation(Intercepts.class);
        for (Class<?> interceptorType : interceptorTypes) {
            if (Interceptor.class.isAssignableFrom(interceptorType)) {
                this.logger.debug("Found interceptor for " + interceptorType);
                this.registry.register(interceptorType);
                continue;
            }
            if (InterceptorSequence.class.isAssignableFrom(interceptorType)) {
                this.logger.debug("Found interceptor sequence for " + interceptorType);
                this.registry.register(InterceptorRegistrar.parseSequence(interceptorType));
                continue;
            }
            throw new VRaptorException("Annotation " + Intercepts.class + " found in " + interceptorType + ", but it is neither an Interceptor nor an InterceptorSequence.");
        }
    }

    private static Class<? extends Interceptor>[] parseSequence(Class<? extends InterceptorSequence> type) {
        try {
            InterceptorSequence sequence = type.getConstructor(new Class[0]).newInstance(new Object[0]);
            return sequence.getSequence();
        }
        catch (Exception e) {
            throw new VRaptorException("Problem ocurred while instantiating an interceptor sequence", e);
        }
    }
}

