/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.pico;

import br.com.caelum.vraptor.ComponentRegistry;
import br.com.caelum.vraptor.config.BasicConfiguration;
import br.com.caelum.vraptor.converter.jodatime.LocalDateConverter;
import br.com.caelum.vraptor.converter.jodatime.LocalTimeConverter;
import br.com.caelum.vraptor.core.BaseComponents;
import br.com.caelum.vraptor.core.Execution;
import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.ioc.Component;
import br.com.caelum.vraptor.ioc.ComponentFactory;
import br.com.caelum.vraptor.ioc.ContainerProvider;
import br.com.caelum.vraptor.ioc.StereotypeHandler;
import br.com.caelum.vraptor.ioc.pico.ComponentFactoryRegistrar;
import br.com.caelum.vraptor.ioc.pico.ConverterRegistrar;
import br.com.caelum.vraptor.ioc.pico.DefaultComponentFactoryRegistry;
import br.com.caelum.vraptor.ioc.pico.InterceptorRegistrar;
import br.com.caelum.vraptor.ioc.pico.PicoBasedContainer;
import br.com.caelum.vraptor.ioc.pico.PicoComponentRegistry;
import br.com.caelum.vraptor.ioc.pico.ReflectionsScanner;
import br.com.caelum.vraptor.ioc.pico.ResourceRegistrar;
import br.com.caelum.vraptor.ioc.pico.Scanner;
import br.com.caelum.vraptor.ioc.pico.StereotypedComponentRegistrar;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletContext;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.Caching;
import org.picocontainer.lifecycle.JavaEE5LifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicoProvider
implements ContainerProvider {
    private final MutablePicoContainer picoContainer = new DefaultPicoContainer((org.picocontainer.ComponentFactory)new Caching(), (LifecycleStrategy)new JavaEE5LifecycleStrategy((ComponentMonitor)new NullComponentMonitor()), null);
    private MutablePicoContainer childContainer;
    private static final Logger logger = LoggerFactory.getLogger(PicoProvider.class);

    public PicoProvider() {
        DefaultComponentFactoryRegistry componentFactoryRegistry = new DefaultComponentFactoryRegistry();
        PicoComponentRegistry componentRegistry = new PicoComponentRegistry(this.picoContainer, componentFactoryRegistry);
        this.picoContainer.addComponent((Object)componentRegistry);
        this.picoContainer.addComponent((Object)componentFactoryRegistry);
    }

    @Override
    public final void start(ServletContext context) {
        logger.warn("PicoProvider is deprecated. Use SpringProvider for VRaptor instead");
        PicoComponentRegistry componentRegistry = this.getComponentRegistry();
        this.registerBundledComponents(componentRegistry);
        this.picoContainer.addComponent((Object)context);
        BasicConfiguration config = new BasicConfiguration(context);
        ReflectionsScanner scanner = new ReflectionsScanner(config);
        this.picoContainer.addComponent((Object)scanner);
        this.registerAnnotatedComponents(scanner, componentRegistry);
        this.getComponentRegistry().init();
        StereotypedComponentRegistrar componentRegistrar = (StereotypedComponentRegistrar)this.picoContainer.getComponent(StereotypedComponentRegistrar.class);
        componentRegistrar.registerFrom(scanner);
        this.registerCustomComponents((PicoContainer)this.picoContainer, scanner);
        this.picoContainer.start();
        this.registerCacheComponents();
    }

    private void registerCacheComponents() {
        PicoComponentRegistry registry = this.getComponentRegistry();
        this.childContainer = registry.makeChildContainer();
        Map<Class<?>, Class<?>> cachedComponents = BaseComponents.getCachedComponents();
        for (Map.Entry<Class<?>, Class<?>> entry : cachedComponents.entrySet()) {
            registry.register(entry.getKey(), entry.getValue());
        }
        this.childContainer.start();
    }

    private void registerAnnotatedComponents(Scanner scanner, ComponentRegistry componentRegistry) {
        Collection<Class<?>> collection = scanner.getTypesWithAnnotation(Component.class);
        for (Class<?> componentType : collection) {
            if (ComponentFactory.class.isAssignableFrom(componentType)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Registering found component factory " + componentType);
                }
                componentRegistry.register(componentType, componentType);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Deeply registering found component " + componentType);
            }
            componentRegistry.deepRegister(componentType);
        }
    }

    protected void registerBundledComponents(ComponentRegistry registry) {
        logger.debug("Registering base pico container related implementation components");
        for (Class<? extends StereotypeHandler> clazz : BaseComponents.getStereotypeHandlers()) {
            registry.register(clazz, clazz);
        }
        for (Map.Entry<Class<?>, Class<?>> entry : BaseComponents.getApplicationScoped().entrySet()) {
            registry.register(entry.getKey(), entry.getValue());
            registry.register(entry.getValue(), entry.getValue());
        }
        for (Map.Entry<Class<?>, Class<?>> entry : BaseComponents.getRequestScoped().entrySet()) {
            registry.register(entry.getKey(), entry.getValue());
            registry.register(entry.getValue(), entry.getValue());
        }
        for (Map.Entry<Class<?>, Class<?>> entry : BaseComponents.getPrototypeScoped().entrySet()) {
            registry.register(entry.getKey(), entry.getValue());
            registry.register(entry.getValue(), entry.getValue());
        }
        for (Class<Object> clazz : BaseComponents.getBundledConverters()) {
            registry.register(clazz, clazz);
        }
        registry.register(ResourceRegistrar.class, ResourceRegistrar.class);
        registry.register(InterceptorRegistrar.class, InterceptorRegistrar.class);
        registry.register(ConverterRegistrar.class, ConverterRegistrar.class);
        registry.register(ComponentFactoryRegistrar.class, ComponentFactoryRegistrar.class);
        registry.register(StereotypedComponentRegistrar.class, StereotypedComponentRegistrar.class);
        try {
            Class.forName("org.joda.time.LocalDate");
            registry.register(LocalDateConverter.class, LocalDateConverter.class);
            registry.register(LocalTimeConverter.class, LocalTimeConverter.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected void registerCustomComponents(PicoContainer picoContainer, Scanner scanner) {
    }

    @Override
    public void stop() {
        this.picoContainer.stop();
        this.picoContainer.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T provideForRequest(RequestInfo request, Execution<T> execution) {
        PicoBasedContainer container = null;
        try {
            container = this.getComponentRegistry().provideRequestContainer(request);
            container.getContainer().start();
            T t = execution.insideRequest(container);
            return t;
        }
        finally {
            if (container != null) {
                MutablePicoContainer picoContainer = container.getContainer();
                picoContainer.stop();
                picoContainer.dispose();
            }
        }
    }

    protected PicoComponentRegistry getComponentRegistry() {
        return (PicoComponentRegistry)this.picoContainer.getComponent(PicoComponentRegistry.class);
    }
}

