/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.pico;

import br.com.caelum.vraptor.config.BasicConfiguration;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.Stereotype;
import br.com.caelum.vraptor.ioc.pico.Scanner;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.ClassAnnotationsScanner;
import org.reflections.scanners.SubTypesScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class ReflectionsScanner
implements Scanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionsScanner.class);
    private final Reflections reflections;

    public ReflectionsScanner(BasicConfiguration config) {
        if (!config.hasBasePackages()) {
            throw new IllegalArgumentException("picoprovider has no support for webinf scanner");
        }
        if (config.getBasePackages().length > 1) {
            throw new IllegalArgumentException("picoprovider has no support for multiple package scanning");
        }
        String packages = config.getBasePackages()[0];
        this.reflections = new Reflections(packages, new org.reflections.scanners.Scanner[]{new ClassAnnotationsScanner(), new SubTypesScanner()});
    }

    @Override
    public Collection<Class<?>> getTypesWithAnnotation(Class<? extends Annotation> annotationType) {
        return this.reflections.getTypesAnnotatedWith(annotationType);
    }

    @Override
    public Collection<Class<?>> getTypesWithMetaAnnotation(Class<? extends Annotation> metaAnnotationType) {
        Set stereotypeAnnotations = this.reflections.getTypesAnnotatedWith(Stereotype.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found the following sterotyped annotations: " + stereotypeAnnotations.toString());
        }
        HashSet componentTypes = new HashSet();
        for (Class stereotypeAnnotation : stereotypeAnnotations) {
            Set annotatedComponents = this.reflections.getTypesAnnotatedWith(stereotypeAnnotation);
            componentTypes.addAll(annotatedComponents);
        }
        return componentTypes;
    }

    @Override
    public <T> Collection<Class<? extends T>> getSubtypesOfWithAnnotation(Class<T> requiredType, Class<? extends Annotation> annotationType) {
        HashSet<Class<T>> subtypes = new HashSet<Class<T>>();
        Collection<Class<?>> annotatedTypes = this.getTypesWithAnnotation(annotationType);
        for (Class<?> annotatedType : annotatedTypes) {
            if (!requiredType.isAssignableFrom(annotatedType)) continue;
            subtypes.add(annotatedType);
        }
        return subtypes;
    }

    @Override
    public <T> Collection<Class<? extends T>> getSubtypesOfWithMetaAnnotation(Class<T> requiredType, Class<? extends Annotation> annotationType) {
        HashSet<Class<T>> subtypes = new HashSet<Class<T>>();
        Collection<Class<?>> annotatedTypes = this.getTypesWithMetaAnnotation(annotationType);
        for (Class<?> annotatedType : annotatedTypes) {
            if (!requiredType.isAssignableFrom(annotatedType)) continue;
            subtypes.add(annotatedType);
        }
        return subtypes;
    }

    @Override
    public <T> Collection<Class<? extends T>> getSubtypesOf(Class<T> type) {
        return this.reflections.getSubTypesOf(type);
    }
}

