/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.pico;

import br.com.caelum.vraptor.ComponentRegistry;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.Stereotype;
import br.com.caelum.vraptor.ioc.StereotypeHandler;
import br.com.caelum.vraptor.ioc.pico.Registrar;
import br.com.caelum.vraptor.ioc.pico.Scanner;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class StereotypedComponentRegistrar
implements Registrar {
    private final Logger logger = LoggerFactory.getLogger(StereotypedComponentRegistrar.class);
    private final ComponentRegistry registry;
    private final List<StereotypeHandler> handlers;

    public StereotypedComponentRegistrar(ComponentRegistry registry, List<StereotypeHandler> handlers) {
        this.registry = registry;
        this.handlers = handlers;
    }

    @Override
    public void registerFrom(Scanner scanner) {
        this.logger.info("Registering all classes with stereotyped annotations (annotations annotated with @Stereotype)");
        for (StereotypeHandler handler : this.handlers) {
            Collection<Class<?>> componentTypes = scanner.getTypesWithAnnotation(handler.stereotype());
            for (Class<?> componentType : componentTypes) {
                this.logger.debug("found component: " + componentType + ", annotated with: " + handler.stereotype());
                handler.handle(componentType);
                this.registry.deepRegister(componentType);
            }
        }
        Collection<Class<?>> componentTypes = scanner.getTypesWithMetaAnnotation(Stereotype.class);
        for (Class<?> componentType : componentTypes) {
            this.logger.debug("found component: " + componentType);
            this.registry.deepRegister(componentType);
        }
    }
}

