/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.spring;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.spring.SpringLocator;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@ApplicationScoped
public class DefaultSpringLocator
implements SpringLocator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSpringLocator.class);

    public ApplicationContext getApplicationContext(ServletContext servletContext) {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (context != null) {
            logger.info("Using a web application context: " + context);
            return context;
        }
        if (DefaultSpringLocator.class.getResource("/applicationContext.xml") != null) {
            logger.info("Using a classpath application context");
            return new ClassPathXmlApplicationContext("classpath:applicationContext.xml");
        }
        logger.info("No application context found");
        return null;
    }
}

