/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.spring;

import br.com.caelum.vraptor.config.BasicConfiguration;
import br.com.caelum.vraptor.ioc.AbstractComponentRegistry;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.ioc.spring.VRaptorApplicationContext;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBasedContainer
extends AbstractComponentRegistry
implements Container {
    private VRaptorApplicationContext applicationContext;
    private final List<Class<?>> toRegister = new ArrayList();

    public SpringBasedContainer(ApplicationContext parentContext, BasicConfiguration config) {
        this.applicationContext = new VRaptorApplicationContext(this, config);
        this.applicationContext.setParent(parentContext);
    }

    @Override
    public void register(Class<?> requiredType, Class<?> componentType) {
        if (this.applicationContext.isActive()) {
            this.applicationContext.register(componentType);
        } else {
            this.toRegister.add(componentType);
        }
    }

    public List<Class<?>> getToRegister() {
        return this.toRegister;
    }

    @Override
    public <T> T instanceFor(Class<T> type) {
        return this.applicationContext.getBean(type);
    }

    @Override
    public <T> boolean canProvide(Class<T> type) {
        return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, type).length > 0;
    }

    public void start(ServletContext context) {
        this.applicationContext.setServletContext(context);
        this.applicationContext.refresh();
        this.applicationContext.start();
    }

    public void stop() {
        this.applicationContext.stop();
        this.applicationContext.destroy();
        this.applicationContext = null;
    }
}

