/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.spring;

import br.com.caelum.vraptor.ComponentRegistry;
import br.com.caelum.vraptor.config.BasicConfiguration;
import br.com.caelum.vraptor.core.Execution;
import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.ioc.ContainerProvider;
import br.com.caelum.vraptor.ioc.spring.DefaultSpringLocator;
import br.com.caelum.vraptor.ioc.spring.SpringBasedContainer;
import br.com.caelum.vraptor.ioc.spring.VRaptorRequestHolder;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.RequestContextListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringProvider
implements ContainerProvider {
    private final RequestContextListener requestListener = new RequestContextListener();
    private SpringBasedContainer container;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T provideForRequest(RequestInfo request, Execution<T> execution) {
        T result;
        if (this.springListenerAlreadyCalled()) {
            return execution.insideRequest(this.getContainer());
        }
        VRaptorRequestHolder.setRequestForCurrentThread(request);
        try {
            ServletContext context = request.getServletContext();
            MutableRequest webRequest = request.getRequest();
            this.requestListener.requestInitialized(new ServletRequestEvent(context, (ServletRequest)webRequest));
            try {
                result = execution.insideRequest(this.getContainer());
            }
            finally {
                this.requestListener.requestDestroyed(new ServletRequestEvent(context, (ServletRequest)webRequest));
            }
        }
        finally {
            VRaptorRequestHolder.resetRequestForCurrentThread();
        }
        return result;
    }

    protected SpringBasedContainer getContainer() {
        return this.container;
    }

    @Override
    public void stop() {
        this.container.stop();
    }

    @Override
    public void start(ServletContext context) {
        BasicConfiguration config = new BasicConfiguration(context);
        this.container = new SpringBasedContainer(this.getParentApplicationContext(context), config);
        this.registerCustomComponents(this.container);
        this.container.start(context);
    }

    protected void registerCustomComponents(ComponentRegistry registry) {
    }

    protected ApplicationContext getParentApplicationContext(ServletContext context) {
        return new DefaultSpringLocator().getApplicationContext(context);
    }

    private boolean springListenerAlreadyCalled() {
        return RequestContextHolder.getRequestAttributes() != null;
    }
}

