/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.spring;

import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.config.BasicConfiguration;
import br.com.caelum.vraptor.converter.jodatime.LocalDateConverter;
import br.com.caelum.vraptor.converter.jodatime.LocalTimeConverter;
import br.com.caelum.vraptor.core.BaseComponents;
import br.com.caelum.vraptor.ioc.ComponentFactory;
import br.com.caelum.vraptor.ioc.StereotypeHandler;
import br.com.caelum.vraptor.ioc.spring.ComponentFactoryBean;
import br.com.caelum.vraptor.ioc.spring.ComponentScanner;
import br.com.caelum.vraptor.ioc.spring.DefaultSpringLocator;
import br.com.caelum.vraptor.ioc.spring.HttpServletRequestProvider;
import br.com.caelum.vraptor.ioc.spring.HttpServletResponseProvider;
import br.com.caelum.vraptor.ioc.spring.HttpSessionProvider;
import br.com.caelum.vraptor.ioc.spring.InjectionBeanPostProcessor;
import br.com.caelum.vraptor.ioc.spring.SpringBasedContainer;
import br.com.caelum.vraptor.ioc.spring.StereotypedBeansRegistrar;
import br.com.caelum.vraptor.ioc.spring.VRaptorRequestProvider;
import br.com.caelum.vraptor.ioc.spring.VRaptorScopeResolver;
import br.com.caelum.vraptor.ioc.spring.WebinfClassesPatternResolver;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.config.AopConfigUtils;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.support.AbstractRefreshableWebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VRaptorApplicationContext
extends AbstractRefreshableWebApplicationContext {
    private static final Logger logger = LoggerFactory.getLogger(VRaptorApplicationContext.class);
    public static final String RESOURCES_LIST = "br.com.caelum.vraptor.resources.list";
    private final AnnotationBeanNameGenerator beanNameGenerator = new AnnotationBeanNameGenerator();
    private final SpringBasedContainer container;
    private final BasicConfiguration config;

    public VRaptorApplicationContext(SpringBasedContainer container, BasicConfiguration config) {
        this.container = container;
        this.config = config;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        WebApplicationContextUtils.registerWebApplicationScopes((ConfigurableListableBeanFactory)beanFactory);
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) {
        if (this.getParent() == null || this.getParent().getBeanNamesForType(ServletContext.class).length == 0) {
            beanFactory.registerSingleton(ServletContext.class.getName(), (Object)this.config.getServletContext());
        }
        this.registerApplicationScopedComponentsOn(beanFactory);
        this.registerRequestScopedComponentsOn(beanFactory);
        this.registerPrototypeScopedComponentsOn(beanFactory);
        this.registerCustomComponentsOn(beanFactory);
        String directory = this.config.getWebinfClassesDirectory();
        if (directory != null) {
            logger.info("Scanning WEB-INF/classes: " + directory);
            ComponentScanner scanner = new ComponentScanner(beanFactory, this.container);
            scanner.setResourcePattern("**/*.class");
            scanner.setResourceLoader((ResourceLoader)new WebinfClassesPatternResolver(this.config.getWebinfClassesDirectory()));
            scanner.scan("");
        } else {
            logger.warn("Cant invoke ServletContext.getRealPath. Some application servers, as WebLogic, must be configured to be able to do so.Not scanning WEB-INF/classes for VRaptor and Spring components.");
        }
        if (this.config.hasBasePackages()) {
            ComponentScanner scanner = new ComponentScanner(beanFactory, this.container);
            logger.info("Scanning packages from WEB-INF/classes and jars: " + Arrays.toString(this.config.getBasePackages()));
            scanner.scan(this.config.getBasePackages());
        }
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)beanFactory);
        AopConfigUtils.registerAspectJAnnotationAutoProxyCreatorIfNecessary((BeanDefinitionRegistry)beanFactory);
        this.registerCustomInjectionProcessor((BeanDefinitionRegistry)beanFactory);
        this.registerCachedComponentsOn(beanFactory);
    }

    private void registerCustomComponentsOn(DefaultListableBeanFactory beanFactory) {
        for (Class<?> type : this.container.getToRegister()) {
            this.register(type, (ConfigurableListableBeanFactory)beanFactory);
        }
    }

    private void registerPrototypeScopedComponentsOn(DefaultListableBeanFactory beanFactory) {
        for (Class<?> prototypeComponent : BaseComponents.getPrototypeScoped().values()) {
            this.registerOn((BeanDefinitionRegistry)beanFactory, prototypeComponent);
        }
    }

    private void registerCachedComponentsOn(DefaultListableBeanFactory beanFactory) {
        for (Class<?> cachedComponent : BaseComponents.getCachedComponents().values()) {
            this.registerOn((BeanDefinitionRegistry)beanFactory, cachedComponent, true);
        }
    }

    private void registerApplicationScopedComponentsOn(DefaultListableBeanFactory beanFactory) {
        for (Class<?> type : BaseComponents.getApplicationScoped().values()) {
            this.registerOn((BeanDefinitionRegistry)beanFactory, type);
            this.registerFactory(type, (ConfigurableListableBeanFactory)beanFactory);
        }
        for (Class<? extends StereotypeHandler> handlerType : BaseComponents.getStereotypeHandlers()) {
            this.registerOn((BeanDefinitionRegistry)beanFactory, handlerType);
        }
        this.registerOn((BeanDefinitionRegistry)beanFactory, StereotypedBeansRegistrar.class);
        this.registerOn((BeanDefinitionRegistry)beanFactory, DefaultSpringLocator.class);
        this.config.getServletContext();
    }

    private void registerRequestScopedComponentsOn(DefaultListableBeanFactory beanFactory) {
        for (Class<?> type : BaseComponents.getRequestScoped().values()) {
            this.registerOn((BeanDefinitionRegistry)beanFactory, type);
            this.registerFactory(type, (ConfigurableListableBeanFactory)beanFactory);
        }
        for (Class<? extends Converter<?>> converterType : BaseComponents.getBundledConverters()) {
            this.registerOn((BeanDefinitionRegistry)beanFactory, converterType);
        }
        this.registerOn((BeanDefinitionRegistry)beanFactory, VRaptorRequestProvider.class, true);
        this.registerOn((BeanDefinitionRegistry)beanFactory, HttpServletRequestProvider.class, true);
        this.registerOn((BeanDefinitionRegistry)beanFactory, HttpServletResponseProvider.class, true);
        this.registerOn((BeanDefinitionRegistry)beanFactory, HttpSessionProvider.class, true);
        beanFactory.registerSingleton(SpringBasedContainer.class.getName(), (Object)this.container);
        try {
            Class.forName("org.joda.time.LocalDate");
            this.registerOn((BeanDefinitionRegistry)beanFactory, LocalDateConverter.class);
            this.registerOn((BeanDefinitionRegistry)beanFactory, LocalTimeConverter.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void register(Class<?> type, ConfigurableListableBeanFactory beanFactory) {
        this.registerOn((BeanDefinitionRegistry)beanFactory, type, true);
        this.registerFactory(type, beanFactory);
    }

    private void registerFactory(Class<?> type, ConfigurableListableBeanFactory beanFactory) {
        if (ComponentFactory.class.isAssignableFrom(type)) {
            beanFactory.registerSingleton(type.getName(), new ComponentFactoryBean(this.container, type));
        }
    }

    public void register(Class<?> type) {
        this.register(type, this.getBeanFactory());
    }

    private void registerOn(BeanDefinitionRegistry registry, Class<?> type) {
        this.registerOn(registry, type, false);
    }

    private void registerOn(BeanDefinitionRegistry registry, Class<?> type, boolean customComponent) {
        AnnotatedGenericBeanDefinition definition = new AnnotatedGenericBeanDefinition(type);
        definition.setLazyInit(true);
        definition.setAutowireMode(0);
        if (customComponent) {
            definition.setPrimary(true);
            definition.setRole(0);
        } else {
            definition.setPrimary(false);
            definition.setRole(2);
        }
        String name = this.beanNameGenerator.generateBeanName((BeanDefinition)definition, registry);
        BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder((BeanDefinition)definition, name);
        VRaptorScopeResolver scopeResolver = new VRaptorScopeResolver();
        ScopeMetadata scopeMetadata = scopeResolver.resolveScopeMetadata((BeanDefinition)definition);
        definitionHolder = this.applyScopeOn(registry, definitionHolder, scopeMetadata);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)registry);
    }

    private BeanDefinitionHolder applyScopeOn(BeanDefinitionRegistry registry, BeanDefinitionHolder definition, ScopeMetadata scopeMetadata) {
        String scope = scopeMetadata.getScopeName();
        ScopedProxyMode proxyMode = scopeMetadata.getScopedProxyMode();
        definition.getBeanDefinition().setScope(scope);
        if ("singleton".equals(scope) || "prototype".equals(scope) || proxyMode.equals((Object)ScopedProxyMode.NO)) {
            return definition;
        }
        boolean proxyTargetClass = proxyMode.equals((Object)ScopedProxyMode.TARGET_CLASS);
        return ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)definition, (BeanDefinitionRegistry)registry, (boolean)proxyTargetClass);
    }

    private void registerCustomInjectionProcessor(BeanDefinitionRegistry registry) {
        RootBeanDefinition definition = new RootBeanDefinition(InjectionBeanPostProcessor.class);
        definition.setRole(2);
        definition.getPropertyValues().addPropertyValue("order", (Object)Integer.MAX_VALUE);
        registry.registerBeanDefinition("org.springframework.context.annotation.internalAutowiredAnnotationProcessor", (BeanDefinition)definition);
    }

    public <T> T getBean(Class<T> type) {
        Map instances = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this, type);
        if (instances.size() == 0) {
            throw new NoSuchBeanDefinitionException(type, "no bean for this type registered");
        }
        if (instances.size() == 1) {
            return (T)instances.values().iterator().next();
        }
        for (Map.Entry entry : instances.entrySet()) {
            BeanDefinition definition = this.getBeanFactory().getBeanDefinition((String)entry.getKey());
            if (this.isPrimary(definition)) {
                return (T)entry.getValue();
            }
            if (!this.hasGreaterRoleThanInfrastructure(definition)) continue;
            return (T)entry.getValue();
        }
        throw new NoSuchBeanDefinitionException("there are " + instances.size() + " implementations for the type [" + type + "], but none of them is primary or has a Role greater than BeanDefinition.ROLE_INFRASTRUCTURE");
    }

    private boolean isPrimary(BeanDefinition definition) {
        return definition instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)definition).isPrimary();
    }

    private boolean hasGreaterRoleThanInfrastructure(BeanDefinition definition) {
        return definition.getRole() < 2;
    }
}

