/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.proxy;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.proxy.AbstractCglibProxifier;
import br.com.caelum.vraptor.proxy.DynamicProxyInvocation;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.ProxyCreationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.NoOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultProxifier
extends AbstractCglibProxifier {
    private final Logger logger = LoggerFactory.getLogger(DefaultProxifier.class);

    public Object proxify(Class type, MethodInvocation handler) {
        if (type.isInterface()) {
            return this.useDynamicProxy(type, handler);
        }
        return this.useCGLib(type, handler);
    }

    private Object useDynamicProxy(Class type, MethodInvocation handler) {
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{type}, (InvocationHandler)new DynamicProxyInvocation(handler));
    }

    private Object useCGLib(Class type, MethodInvocation handler) {
        Enhancer enhancer = this.enhanceTypeWithCGLib(type, handler);
        enhancer.setCallbacks(new Callback[]{this.cglibMethodInterceptor(handler), NoOp.INSTANCE});
        Constructor[] constructors = type.getDeclaredConstructors();
        Constructor defaultConstructor = this.findDefaultConstructor(constructors);
        if (defaultConstructor != null) {
            this.logger.trace("Default constructor found in: " + type);
            return this.useDefaultConstructor(enhancer);
        }
        this.logger.info(String.format("No default constructor found for %s. Trying to create the proxy with other constructors (there are %d).", type, constructors.length));
        return this.tryAllConstructors(type, enhancer, constructors);
    }

    private Object useDefaultConstructor(Enhancer enhancer) {
        return enhancer.create();
    }

    private Object tryAllConstructors(Class type, Enhancer enhancer, Constructor[] constructors) {
        ArrayList<Throwable> problems = new ArrayList<Throwable>();
        for (Constructor constructor : constructors) {
            Object[] parameterTypes = constructor.getParameterTypes();
            Object[] parameterValues = this.proxyParameters((Class[])parameterTypes);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("trying constructor with following parameters types: " + Arrays.toString(parameterTypes) + "values are going to be: " + Arrays.toString(parameterValues));
            }
            try {
                return enhancer.create((Class[])parameterTypes, parameterValues);
            }
            catch (Throwable e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Problem while calling constructor with parameters" + Arrays.toString(constructor.getParameterTypes()) + ". Trying next.", e);
                }
                problems.add(e);
            }
        }
        String message = String.format("Tried to instantiate type: %s %d times, but none of the attempts worked. The exceptions are: %s", type, constructors.length, problems);
        throw new ProxyCreationException(message);
    }

    private Object[] proxyParameters(Class[] parameterTypes) {
        return new Object[parameterTypes.length];
    }

    private Constructor findDefaultConstructor(Constructor[] constructors) {
        for (Constructor constructor : constructors) {
            if (constructor.getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }
}

