/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.reflection;

import br.com.caelum.vraptor.http.AbstractTypeCreator;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.http.TypeCreator;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.resource.ResourceMethod;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class CacheBasedTypeCreator
extends AbstractTypeCreator {
    private static final Logger logger = LoggerFactory.getLogger(CacheBasedTypeCreator.class);
    private final Map<Method, Class<?>> cache = new HashMap();
    private final TypeCreator creator;

    public CacheBasedTypeCreator(TypeCreator creator, ParameterNameProvider provider) {
        super(provider);
        this.creator = creator;
    }

    @Override
    public Class<?> typeFor(ResourceMethod method) {
        if (!this.cache.containsKey(method.getMethod())) {
            this.cache.put(method.getMethod(), this.creator.typeFor(method));
            logger.debug("cached generic type for method " + method);
        }
        return this.cache.get(method.getMethod());
    }
}

