/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.restfulie.controller;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.core.Routes;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.resource.HttpMethod;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.restfulie.Restfulie;
import br.com.caelum.vraptor.restfulie.controller.ParameterizedTypeSearcher;
import br.com.caelum.vraptor.restfulie.controller.ResourceControl;
import br.com.caelum.vraptor.restfulie.hypermedia.HypermediaResource;
import br.com.caelum.vraptor.restfulie.hypermedia.Transition;
import br.com.caelum.vraptor.restfulie.relation.Relation;
import br.com.caelum.vraptor.view.Status;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RequestScoped
public class ResourceControllerInterceptor<T extends HypermediaResource>
implements Interceptor {
    private final ResourceControl<T> control;
    private final List<Class<?>> controllers;
    private final Status status;
    private final Restfulie restfulie;
    private final Routes routes;
    private final RequestInfo info;
    private final ParameterizedTypeSearcher searcher = new ParameterizedTypeSearcher();

    public ResourceControllerInterceptor(ResourceControl<T> control, Restfulie restfulie, Status status, RequestInfo info, Routes routes) {
        this.control = control;
        this.restfulie = restfulie;
        this.status = status;
        this.info = info;
        this.routes = routes;
        this.controllers = Arrays.asList(control.getControllers());
    }

    @Override
    public boolean accepts(ResourceMethod method) {
        return this.controllers.contains(method.getResource().getType()) && method.getMethod().isAnnotationPresent(Transition.class);
    }

    @Override
    public void intercept(InterceptorStack stack, ResourceMethod method, Object instance) throws InterceptionException {
        ParameterizedType type = this.searcher.search(this.control.getClass());
        if (this.analyzeImplementation(method, type)) {
            stack.next(method, instance);
        }
    }

    private boolean analyzeImplementation(ResourceMethod method, ParameterizedType parameterized) {
        Type parameterType = parameterized.getActualTypeArguments()[0];
        Class found = (Class)parameterType;
        T resource = this.retrieveResource(found);
        if (resource == null) {
            this.status.notFound();
            return false;
        }
        if (this.allows(resource, method.getMethod())) {
            return true;
        }
        this.status.methodNotAllowed(this.allowedMethods());
        return false;
    }

    private EnumSet<HttpMethod> allowedMethods() {
        EnumSet<HttpMethod> allowed = this.routes.allowedMethodsFor(this.info.getRequestedUri());
        allowed.remove((Object)HttpMethod.of(this.info.getRequest()));
        return allowed;
    }

    private T retrieveResource(Class<?> found) {
        String parameterName = this.lowerFirstChar(found.getSimpleName()) + ".id";
        String id = this.info.getRequest().getParameter(parameterName);
        HypermediaResource resource = (HypermediaResource)this.control.retrieve(id);
        return (T)resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allows(T resource, Method method) {
        try {
            List<Relation> transitions = resource.getRelations(this.restfulie);
            for (Relation transition : transitions) {
                if (!transition.matches(method)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.restfulie.clear();
        }
    }

    private String lowerFirstChar(String simpleName) {
        if (simpleName.length() == 1) {
            return simpleName.toLowerCase();
        }
        return Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
    }
}

